/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class RubyNumeric
extends RubyObject {
    static /* synthetic */ Class class$org$jruby$RubyNumeric;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;

    public RubyNumeric(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public abstract double getDoubleValue();

    public abstract long getLongValue();

    public long getTruncatedLongValue() {
        return this.getLongValue();
    }

    public static RubyClass createNumericClass(Ruby ruby) {
        RubyClass numericClass = ruby.defineClass("Numeric", ruby.getClasses().getObjectClass());
        numericClass.includeModule(ruby.getClasses().getComparableModule());
        numericClass.defineMethod("coerce", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "coerce", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyNumeric.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        numericClass.defineMethod("clone", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "rbClone"));
        numericClass.defineMethod("+@", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "op_uplus"));
        numericClass.defineMethod("-@", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "op_uminus"));
        numericClass.defineMethod("===", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "equal", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyNumeric.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        numericClass.defineMethod("eql?", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "eql", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyNumeric.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        numericClass.defineMethod("divmod", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "divmod", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyNumeric.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        numericClass.defineMethod("modulo", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "modulo", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyNumeric.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        numericClass.defineMethod("remainder", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "remainder", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyNumeric.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        numericClass.defineMethod("abs", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "abs"));
        numericClass.defineMethod("integer?", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "int_p"));
        numericClass.defineMethod("zero?", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "zero_p"));
        numericClass.defineMethod("nonzero?", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "nonzero_p"));
        numericClass.defineMethod("floor", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "floor"));
        numericClass.defineMethod("ceil", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "ceil"));
        numericClass.defineMethod("round", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "round"));
        numericClass.defineMethod("truncate", CallbackFactory.getMethod(class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyNumeric.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, "truncate"));
        return numericClass;
    }

    public static long num2long(IRubyObject arg) {
        if (arg instanceof RubyNumeric) {
            return ((RubyNumeric)arg).getLongValue();
        }
        throw new TypeError(arg.getRuntime(), "argument is not numeric");
    }

    public static long fix2long(IRubyObject arg) {
        if (arg instanceof RubyFixnum) {
            return ((RubyFixnum)arg).getLongValue();
        }
        throw new TypeError(arg.getRuntime(), "argument is not a Fixnum");
    }

    public static int fix2int(IRubyObject arg) {
        long val = RubyNumeric.fix2long(arg);
        if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
            throw new TypeError(arg.getRuntime(), "argument value is too big to convert to int");
        }
        return (int)val;
    }

    public static final RubyNumeric numericValue(IRubyObject arg) {
        if (!(arg instanceof RubyNumeric)) {
            throw new TypeError(arg.getRuntime(), "argument not numeric");
        }
        return (RubyNumeric)arg;
    }

    public static RubyInteger str2inum(Ruby ruby, RubyString str, int base) {
        StringBuffer sbuf = new StringBuffer(str.getValue().trim());
        if (sbuf.length() == 0) {
            return RubyFixnum.zero(ruby);
        }
        int pos = 0;
        int radix = base != 0 ? base : 10;
        boolean digitsFound = false;
        if (sbuf.charAt(pos) == '-') {
            ++pos;
        } else if (sbuf.charAt(pos) == '+') {
            sbuf.deleteCharAt(pos);
        }
        if (pos == sbuf.length()) {
            return RubyFixnum.zero(ruby);
        }
        if (sbuf.charAt(pos) == '0') {
            sbuf.deleteCharAt(pos);
            if (pos == sbuf.length()) {
                return RubyFixnum.zero(ruby);
            }
            if (sbuf.charAt(pos) == 'x' || sbuf.charAt(pos) == 'X') {
                if (base == 0 || base == 16) {
                    radix = 16;
                    sbuf.deleteCharAt(pos);
                }
            } else if (sbuf.charAt(pos) == 'b' || sbuf.charAt(pos) == 'B') {
                if (base == 0 || base == 2) {
                    radix = 2;
                    sbuf.deleteCharAt(pos);
                }
            } else {
                radix = base == 0 ? 8 : base;
            }
        }
        while (pos < sbuf.length()) {
            if (sbuf.charAt(pos) == '_') {
                sbuf.deleteCharAt(pos);
                continue;
            }
            if (Character.digit(sbuf.charAt(pos), radix) == -1) break;
            digitsFound = true;
            ++pos;
        }
        if (!digitsFound) {
            return RubyFixnum.zero(ruby);
        }
        try {
            long l = Long.parseLong(sbuf.substring(0, pos), radix);
            return RubyFixnum.newFixnum(ruby, l);
        }
        catch (NumberFormatException ex) {
            BigInteger bi = new BigInteger(sbuf.substring(0, pos), radix);
            return new RubyBignum(ruby, bi);
        }
    }

    public static RubyFloat str2fnum(Ruby ruby, RubyString arg) {
        String str = arg.getValue().trim();
        double d = 0.0;
        int pos = str.length();
        int i = 0;
        while (i < pos) {
            if ("0123456789eE+-.".indexOf(str.charAt(i)) == -1) {
                pos = i + 1;
                break;
            }
            ++i;
        }
        while (pos > 0) {
            try {
                d = Double.parseDouble(str.substring(0, pos));
                break;
            }
            catch (NumberFormatException ex) {
                --pos;
            }
        }
        return new RubyFloat(ruby, d);
    }

    public RubyArray coerce(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (this.getMetaClass() == other.getMetaClass()) {
            return RubyArray.newArray(this.getRuntime(), other, this);
        }
        return RubyArray.newArray(this.getRuntime(), RubyFloat.newFloat(this.getRuntime(), other.getDoubleValue()), RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()));
    }

    public RubyNumeric[] getCoerce(RubyNumeric other) {
        if (this.getMetaClass() == other.getMetaClass()) {
            return new RubyNumeric[]{this, other};
        }
        return new RubyNumeric[]{RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()), RubyFloat.newFloat(this.getRuntime(), other.getDoubleValue())};
    }

    public IRubyObject rbClone() {
        return this;
    }

    public RubyNumeric op_uplus() {
        return this;
    }

    public RubyNumeric op_uminus() {
        RubyNumeric[] coerce = this.getCoerce(RubyFixnum.zero(this.getRuntime()));
        return (RubyNumeric)coerce[1].callMethod("-", coerce[0]);
    }

    public RubyArray divmod(IRubyObject val) {
        RubyNumeric other = RubyNumeric.numericValue(val);
        RubyNumeric div = (RubyNumeric)this.callMethod("/", other);
        if (div instanceof RubyFloat) {
            double d = Math.floor(((RubyFloat)div).getValue());
            if (((RubyFloat)div).getValue() > d) {
                div = RubyFloat.newFloat(this.getRuntime(), d);
            }
        }
        RubyNumeric mod = (RubyNumeric)this.callMethod("%", other);
        return RubyArray.newArray(this.getRuntime(), div, mod);
    }

    public RubyNumeric modulo(IRubyObject val) {
        RubyNumeric other = RubyNumeric.numericValue(val);
        return (RubyNumeric)this.callMethod("%", other);
    }

    public RubyNumeric remainder(IRubyObject val) {
        RubyNumeric other = RubyNumeric.numericValue(val);
        RubyNumeric mod = (RubyNumeric)this.callMethod("%", other);
        RubyFixnum zero = RubyFixnum.zero(this.getRuntime());
        if (this.callMethod("<", zero).isTrue() && other.callMethod(">", zero).isTrue() || this.callMethod(">", zero).isTrue() && other.callMethod("<", zero).isTrue()) {
            return (RubyNumeric)mod.callMethod("-", other);
        }
        return mod;
    }

    public RubyBoolean equal(IRubyObject other) {
        return super.equal(other);
    }

    public RubyBoolean eql(IRubyObject other) {
        if (this.getMetaClass() != other.getMetaClass()) {
            return this.getRuntime().getFalse();
        }
        return super.equal(other);
    }

    public RubyNumeric abs() {
        if (this.callMethod("<", RubyFixnum.zero(this.getRuntime())).isTrue()) {
            return (RubyNumeric)this.callMethod("-@");
        }
        return this;
    }

    public RubyBoolean int_p() {
        return this.getRuntime().getFalse();
    }

    public RubyBoolean zero_p() {
        return this.equal(RubyFixnum.zero(this.getRuntime()));
    }

    public IRubyObject nonzero_p() {
        if (this.callMethod("zero?").isTrue()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    public RubyInteger floor() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).floor();
    }

    public RubyInteger ceil() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).ceil();
    }

    public RubyInteger round() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).round();
    }

    public RubyInteger truncate() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).truncate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

