/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.FrozenError;
import org.jruby.exceptions.IndexError;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.SecurityError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Asserts;
import org.jruby.util.IdUtil;

public class RubyStruct
extends RubyObject {
    private IRubyObject[] values;
    static /* synthetic */ Class class$org$jruby$RubyStruct;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;

    public RubyStruct(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createStructClass(Ruby ruby) {
        RubyClass structClass = ruby.defineClass("Struct", ruby.getClasses().getObjectClass());
        structClass.includeModule(ruby.getClasses().getEnumerableModule());
        structClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "newInstance"));
        structClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "initialize"));
        structClass.defineMethod("clone", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "rbClone"));
        structClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "equal", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyStruct.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        structClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "to_s"));
        structClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "inspect"));
        structClass.defineMethod("to_a", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "to_a"));
        structClass.defineMethod("values", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "to_a"));
        structClass.defineMethod("size", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "size"));
        structClass.defineMethod("length", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "size"));
        structClass.defineMethod("each", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "each"));
        structClass.defineMethod("[]", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "aref", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyStruct.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        structClass.defineMethod("[]=", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "aset", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyStruct.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject, class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyStruct.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        structClass.defineMethod("members", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "members"));
        return structClass;
    }

    private static IRubyObject getInstanceVariable(RubyClass type, String name) {
        RubyClass structClass = type.getRuntime().getClasses().getStructClass();
        while (type != null && type != structClass) {
            if (type.hasInstanceVariable(name)) {
                return type.getInstanceVariable(name);
            }
            type = type.getSuperClass();
        }
        return type.getRuntime().getNil();
    }

    private RubyClass classOf() {
        return this.getMetaClass() instanceof MetaClass ? this.getMetaClass().getSuperClass() : this.getMetaClass();
    }

    private void modify() {
        if (this.isFrozen()) {
            throw new FrozenError(this.runtime, "Struct is frozen.");
        }
        if (!this.isTaint() && this.runtime.getSafeLevel() >= 4) {
            throw new SecurityError(this.runtime, "Insecure: can't modify struct");
        }
    }

    private IRubyObject setByName(String name, IRubyObject value) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        Asserts.isTrue(!member.isNil(), "uninitialized struct");
        this.modify();
        int i = 0;
        while (i < member.getLength()) {
            if (member.entry(i).asSymbol().equals(name)) {
                this.values[i] = value;
                return this.values[i];
            }
            ++i;
        }
        throw new NameError(this.runtime, name + " is not struct member");
    }

    private IRubyObject getByName(String name) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        Asserts.isTrue(!member.isNil(), "uninitialized struct");
        int i = 0;
        while (i < member.getLength()) {
            if (member.entry(i).asSymbol().equals(name)) {
                return this.values[i];
            }
            ++i;
        }
        throw new NameError(this.runtime, name + " is not struct member");
    }

    public static RubyClass newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyClass newStruct;
        String name = null;
        if (args.length > 0 && args[0] instanceof RubyString) {
            name = args[0].toString();
        }
        RubyArray member = RubyArray.newArray(recv.getRuntime());
        int i = name == null ? 0 : 1;
        while (i < args.length) {
            member.append(RubySymbol.newSymbol(recv.getRuntime(), args[i].asSymbol()));
            ++i;
        }
        if (name == null) {
            newStruct = new RubyClass((RubyClass)recv);
        } else {
            if (!IdUtil.isConstant(name)) {
                throw new NameError(recv.getRuntime(), "identifier " + name + " needs to be constant");
            }
            newStruct = ((RubyClass)recv).defineClassUnder(name, (RubyClass)recv);
        }
        newStruct.setInstanceVariable("__size__", member.length());
        newStruct.setInstanceVariable("__member__", member);
        newStruct.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "newStruct"));
        newStruct.defineSingletonMethod("[]", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "newStruct"));
        newStruct.defineSingletonMethod("members", CallbackFactory.getSingletonMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "members"));
        int i2 = name == null ? 0 : 1;
        while (i2 < args.length) {
            String memberName = args[i2].asSymbol();
            newStruct.defineMethod(memberName, CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? RubyStruct.class$("org.jruby.RubyStruct") : class$org$jruby$RubyStruct, "get"));
            newStruct.defineMethod(memberName + "=", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? RubyStruct.class$("org.jruby.RubyStruct") : class$org$jruby$RubyStruct, "set", class$org$jruby$runtime$builtin$IRubyObject == null ? RubyStruct.class$("org.jruby.runtime.builtin.IRubyObject") : class$org$jruby$runtime$builtin$IRubyObject));
            ++i2;
        }
        return newStruct;
    }

    public static RubyStruct newStruct(IRubyObject recv, IRubyObject[] args) {
        RubyStruct struct = new RubyStruct(recv.getRuntime(), (RubyClass)recv);
        int size = RubyFixnum.fix2int(RubyStruct.getInstanceVariable((RubyClass)recv, "__size__"));
        struct.values = new IRubyObject[size];
        struct.callInit(args);
        return struct;
    }

    public IRubyObject initialize(IRubyObject[] args) {
        this.modify();
        int size = RubyFixnum.fix2int(RubyStruct.getInstanceVariable(this.getMetaClass(), "__size__"));
        if (args.length > size) {
            throw new ArgumentError(this.runtime, "struct size differs (" + args.length + " for " + size + ")");
        }
        int i = 0;
        while (i < args.length) {
            this.values[i] = args[i];
            ++i;
        }
        int i2 = args.length;
        while (i2 < size) {
            this.values[i2] = this.runtime.getNil();
            ++i2;
        }
        return this.runtime.getNil();
    }

    public static RubyArray members(IRubyObject recv) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable((RubyClass)recv, "__member__");
        Asserts.isTrue(!member.isNil(), "uninitialized struct");
        RubyArray result = RubyArray.newArray(recv.getRuntime(), member.getLength());
        int i = 0;
        while (i < member.getLength()) {
            result.append(RubyString.newString(recv.getRuntime(), member.entry(i).asSymbol()));
            ++i;
        }
        return result;
    }

    public RubyArray members() {
        return RubyStruct.members(this.classOf());
    }

    public IRubyObject set(IRubyObject value) {
        RubyArray member;
        String name = this.runtime.getCurrentFrame().getLastFunc();
        if (name.endsWith("=")) {
            name = name.substring(0, name.length() - 1);
        }
        Asserts.isTrue(!(member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__")).isNil(), "uninitialized struct");
        this.modify();
        int i = 0;
        while (i < member.getLength()) {
            if (member.entry(i).asSymbol().equals(name)) {
                this.values[i] = value;
                return this.values[i];
            }
            ++i;
        }
        throw new NameError(this.runtime, name + " is not struct member");
    }

    public IRubyObject get() {
        String name = this.runtime.getCurrentFrame().getLastFunc();
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        Asserts.isTrue(!member.isNil(), "uninitialized struct");
        int i = 0;
        while (i < member.getLength()) {
            if (member.entry(i).asSymbol().equals(name)) {
                return this.values[i];
            }
            ++i;
        }
        throw new NameError(this.runtime, name + " is not struct member");
    }

    public IRubyObject rbClone() {
        RubyStruct clone = new RubyStruct(this.runtime, this.getMetaClass());
        clone.values = new IRubyObject[this.values.length];
        System.arraycopy(this.values, 0, clone.values, 0, this.values.length);
        return clone;
    }

    public RubyBoolean equal(IRubyObject other) {
        if (this == other) {
            return this.runtime.getTrue();
        }
        if (!(other instanceof RubyStruct)) {
            return this.runtime.getFalse();
        }
        if (this.getMetaClass() != other.getMetaClass()) {
            return this.runtime.getFalse();
        }
        int i = 0;
        while (i < this.values.length) {
            if (!this.values[i].equals(((RubyStruct)other).values[i])) {
                return this.runtime.getFalse();
            }
            ++i;
        }
        return this.runtime.getTrue();
    }

    public RubyString to_s() {
        return RubyString.newString(this.runtime, "#<" + this.getMetaClass().toName() + ">");
    }

    public RubyString inspect() {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        Asserts.isTrue(!member.isNil(), "uninitialized struct");
        StringBuffer sb = new StringBuffer(100);
        sb.append("#<").append(this.getMetaClass().toName()).append(' ');
        int i = 0;
        while (i < member.getLength()) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(member.entry(i).asSymbol()).append("=");
            sb.append(this.values[i].callMethod("inspect"));
            ++i;
        }
        sb.append('>');
        return RubyString.newString(this.runtime, sb.toString());
    }

    public RubyArray to_a() {
        return RubyArray.newArray(this.runtime, this.values);
    }

    public RubyFixnum size() {
        return RubyFixnum.newFixnum(this.runtime, this.values.length);
    }

    public IRubyObject each() {
        int i = 0;
        while (i < this.values.length) {
            this.runtime.yield(this.values[i]);
            ++i;
        }
        return this;
    }

    public IRubyObject aref(IRubyObject key) {
        if (key instanceof RubyString || key instanceof RubySymbol) {
            return this.getByName(key.asSymbol());
        }
        int idx = RubyFixnum.fix2int(key);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw new IndexError(this.runtime, "offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw new IndexError(this.runtime, "offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        return this.values[idx];
    }

    public IRubyObject aset(IRubyObject key, IRubyObject value) {
        if (key instanceof RubyString || key instanceof RubySymbol) {
            return this.setByName(key.asSymbol(), value);
        }
        int idx = RubyFixnum.fix2int(key);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw new IndexError(this.runtime, "offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw new IndexError(this.runtime, "offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        this.modify();
        this.values[idx] = value;
        return this.values[idx];
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(83);
        String className = this.getMetaClass().getClassname();
        if (className == null) {
            throw new ArgumentError(this.runtime, "can't dump anonymous class");
        }
        output.dumpObject(RubySymbol.newSymbol(this.runtime, className));
        ArrayList members = ((RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__")).getList();
        output.dumpInt(members.size());
        int i = 0;
        while (i < members.size()) {
            RubySymbol name = (RubySymbol)members.get(i);
            output.dumpObject(name);
            output.dumpObject(this.values[i]);
            ++i;
        }
    }

    public static RubyStruct unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol className;
        Ruby ruby = input.getRuntime();
        RubyClass rbClass = RubyStruct.pathToClass(ruby, (className = (RubySymbol)input.unmarshalObject()).asSymbol());
        if (rbClass == null) {
            throw new NameError(ruby, "uninitialized constant " + className);
        }
        int size = input.unmarshalInt();
        IRubyObject[] values = new IRubyObject[size];
        int i = 0;
        while (i < size) {
            input.unmarshalObject();
            values[i] = input.unmarshalObject();
            ++i;
        }
        RubyStruct result = RubyStruct.newStruct(rbClass, values);
        input.registerLinkTarget(result);
        return result;
    }

    private static RubyClass pathToClass(Ruby ruby, String path) {
        return (RubyClass)ruby.getClasses().getClassFromPath(path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

