/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.TypeError;
import org.jruby.internal.runtime.builtin.definitions.SymbolDefinition;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubySymbol
extends RubyObject
implements IndexCallable {
    private static int lastId = 0;
    private final String symbol;
    private final int id;
    static /* synthetic */ Class class$org$jruby$RubySymbol;

    private RubySymbol(Ruby ruby, String symbol) {
        super(ruby, ruby.getClasses().getSymbolClass());
        this.symbol = symbol;
        this.id = ++lastId;
    }

    public String asSymbol() {
        return this.symbol;
    }

    public static RubySymbol nilSymbol(Ruby ruby) {
        return RubySymbol.newSymbol(ruby, null);
    }

    public static RubyClass createSymbolClass(Ruby ruby) {
        return new SymbolDefinition(ruby).getType();
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 61442: {
                return this.to_s();
            }
            case 61441: {
                return this.to_i();
            }
            case 61443: {
                return this.equal(args[0]);
            }
            case 61444: {
                return this.hash();
            }
            case 61445: {
                return this.inspect();
            }
            case 61446: {
                return this.rbClone();
            }
            case 61447: {
                return this.freeze();
            }
            case 61448: {
                return this.taint();
            }
        }
        return super.callIndexed(index, args);
    }

    public static RubySymbol getSymbol(Ruby ruby, long id) {
        RubySymbol result = ruby.symbolTable.lookup(id);
        if (result == null) {
            return RubySymbol.nilSymbol(ruby);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubySymbol newSymbol(Ruby ruby, String name) {
        RubySymbol result;
        Class clazz = class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubySymbol.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol;
        synchronized (clazz) {
            result = ruby.symbolTable.lookup(name);
            if (result == null) {
                result = name == null ? new RubySymbol(ruby, null){

                    public boolean isNil() {
                        return true;
                    }
                } : new RubySymbol(ruby, name);
                ruby.symbolTable.store(result);
            }
        }
        return result;
    }

    public RubyFixnum to_i() {
        return RubyFixnum.newFixnum(this.runtime, this.id);
    }

    public RubyString inspect() {
        return RubyString.newString(this.getRuntime(), ":" + this.symbol);
    }

    public RubyString to_s() {
        return RubyString.newString(this.getRuntime(), this.symbol);
    }

    public RubyBoolean equal(IRubyObject other) {
        return RubyBoolean.newBoolean(this.runtime, this == other);
    }

    public RubyFixnum hash() {
        return RubyFixnum.newFixnum(this.runtime, this.symbol.hashCode());
    }

    public IRubyObject rbClone() {
        throw new TypeError(this.getRuntime(), "can't clone Symbol");
    }

    public IRubyObject freeze() {
        return this;
    }

    public IRubyObject taint() {
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(58);
        output.dumpString(this.symbol);
    }

    public static RubySymbol unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol result = RubySymbol.newSymbol(input.getRuntime(), input.unmarshalString());
        input.registerLinkTarget(result);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SymbolTable {
        private ReferenceQueue unusedSymbols = new ReferenceQueue();
        private Map table = new HashMap();

        public RubySymbol lookup(String name) {
            this.clean();
            WeakSymbolEntry ref = (WeakSymbolEntry)this.table.get(name);
            if (ref == null) {
                return null;
            }
            return (RubySymbol)ref.get();
        }

        public RubySymbol lookup(long symbolId) {
            Iterator iter = this.table.values().iterator();
            while (iter.hasNext()) {
                WeakSymbolEntry entry = (WeakSymbolEntry)iter.next();
                RubySymbol symbol = (RubySymbol)entry.get();
                if (symbol == null || (long)symbol.id != symbolId) continue;
                return symbol;
            }
            return null;
        }

        public void store(RubySymbol symbol) {
            this.clean();
            this.table.put(symbol.asSymbol(), new WeakSymbolEntry(symbol));
        }

        /*
         * WARNING - void declaration
         */
        private void clean() {
            WeakSymbolEntry ref;
            while ((ref = (WeakSymbolEntry)this.unusedSymbols.poll()) != null) {
                void var1_1;
                this.table.remove(((WeakSymbolEntry)var1_1).name());
            }
        }

        private class WeakSymbolEntry
        extends WeakReference {
            private final String name;

            public WeakSymbolEntry(RubySymbol symbol) {
                super(symbol, SymbolTable.this.unusedSymbols);
                this.name = symbol.asSymbol();
            }

            private String name() {
                return this.name;
            }
        }
    }
}

