/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadError;
import org.jruby.internal.runtime.builtin.definitions.ThreadDefinition;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public class ThreadClass
extends RubyObject
implements IndexCallable {
    private static boolean globalAbortOnException;
    private Thread jvmThread;
    private Map threadLocalVariables = new HashMap();
    private boolean abortOnException;
    private RaiseException exitingException = null;
    private IRubyObject receivedException = null;
    private Object hasStartedLock = new Object();
    private boolean hasStarted = false;

    public static RubyClass createThreadClass(Ruby runtime) {
        RubyClass threadClass = new ThreadDefinition(runtime).getType();
        ThreadClass currentThread = new ThreadClass(runtime, threadClass);
        currentThread.jvmThread = Thread.currentThread();
        runtime.getMainContext().setCurrentThread(currentThread);
        return threadClass;
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        return ThreadClass.startThread(recv, args, true);
    }

    public static ThreadClass start(IRubyObject recv, IRubyObject[] args) {
        return ThreadClass.startThread(recv, args, false);
    }

    private static ThreadClass startThread(IRubyObject recv, final IRubyObject[] args, boolean callInit) {
        final Ruby runtime = recv.getRuntime();
        if (!runtime.isBlockGiven()) {
            throw new ThreadError(runtime, "must be called with a block");
        }
        final ThreadClass thread = new ThreadClass(runtime, (RubyClass)recv);
        if (callInit) {
            thread.callInit(args);
        }
        final RubyProc proc = RubyProc.newProc(runtime);
        final Frame currentFrame = runtime.getCurrentFrame();
        final Block currentBlock = runtime.getBlockStack().getCurrent();
        thread.jvmThread = new Thread(new Runnable(){

            public void run() {
                thread.notifyStarted();
                runtime.registerNewContext(thread);
                ThreadContext context = runtime.getCurrentContext();
                context.getFrameStack().push(currentFrame);
                context.getBlockStack().setCurrent(currentBlock);
                try {
                    proc.call(args);
                }
                catch (RaiseException e) {
                    thread.exceptionRaised(e);
                }
            }
        });
        thread.jvmThread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStarted() {
        Asserts.isTrue(this.isCurrent());
        Object object = this.hasStartedLock;
        synchronized (object) {
            this.hasStarted = true;
            this.hasStartedLock.notifyAll();
        }
    }

    public void pollThreadEvents() {
        this.pollReceivedExceptions();
    }

    private void pollReceivedExceptions() {
        if (this.receivedException != null) {
            RubyModule kernelModule = this.getRuntime().getClasses().getKernelModule();
            kernelModule.callMethod("raise", this.receivedException);
        }
    }

    private ThreadClass(Ruby ruby, RubyClass type) {
        super(ruby, type);
    }

    public static RubyBoolean abort_on_exception(IRubyObject recv) {
        return globalAbortOnException ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    public static IRubyObject abort_on_exception_set(IRubyObject recv, IRubyObject value) {
        globalAbortOnException = value.isTrue();
        return value;
    }

    public static ThreadClass current(IRubyObject recv) {
        return recv.getRuntime().getCurrentContext().getCurrentThread();
    }

    public static IRubyObject pass(IRubyObject recv) {
        Thread.yield();
        return recv.getRuntime().getNil();
    }

    public static RubyArray list(IRubyObject recv) {
        ArrayList list = new ArrayList();
        Iterator iter = recv.getRuntime().objectSpace.iterator(recv.getRuntime().getClasses().getThreadClass());
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return RubyArray.newArray(recv.getRuntime(), list);
    }

    public IRubyObject aref(IRubyObject key) {
        String name = this.keyName(key);
        if (!this.threadLocalVariables.containsKey(name)) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.threadLocalVariables.get(name);
    }

    public IRubyObject aset(IRubyObject key, IRubyObject value) {
        String name = this.keyName(key);
        this.threadLocalVariables.put(name, value);
        return value;
    }

    private String keyName(IRubyObject key) {
        String name;
        if (key instanceof RubySymbol) {
            name = key.asSymbol();
        } else if (key instanceof RubyString) {
            name = ((RubyString)key).getValue();
        } else {
            throw new ArgumentError(this.getRuntime(), key.inspect() + " is not a symbol");
        }
        return name;
    }

    public RubyBoolean abort_on_exception() {
        return this.abortOnException ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject abort_on_exception_set(IRubyObject val) {
        this.abortOnException = val.isTrue();
        return val;
    }

    public RubyBoolean is_alive() {
        return this.jvmThread.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public ThreadClass join() {
        if (this.isCurrent()) {
            throw new ThreadError(this.getRuntime(), "thread tried to join itself");
        }
        this.ensureStarted();
        try {
            this.jvmThread.join();
        }
        catch (InterruptedException iExcptn) {
            Asserts.notReached();
        }
        if (this.exitingException != null) {
            throw this.exitingException;
        }
        return this;
    }

    public RubyBoolean has_key(IRubyObject key) {
        String name = this.keyName(key);
        return RubyBoolean.newBoolean(this.getRuntime(), this.threadLocalVariables.containsKey(name));
    }

    public RubyFixnum priority() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.jvmThread.getPriority());
    }

    public IRubyObject priority_set(IRubyObject priority) {
        this.jvmThread.setPriority(RubyNumeric.fix2int(priority));
        return priority;
    }

    public IRubyObject raise(IRubyObject exc) {
        this.receivedException = exc;
        return this;
    }

    public IRubyObject status() {
        this.ensureStarted();
        if (this.jvmThread.isAlive()) {
            return RubyString.newString(this.getRuntime(), "run");
        }
        if (this.exitingException != null) {
            return this.getRuntime().getNil();
        }
        return RubyBoolean.newBoolean(this.getRuntime(), false);
    }

    private boolean isCurrent() {
        return Thread.currentThread() == this.jvmThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureStarted() {
        if (this.hasStarted) {
            return;
        }
        Object object = this.hasStartedLock;
        synchronized (object) {
            if (!this.hasStarted) {
                try {
                    this.hasStartedLock.wait();
                }
                catch (InterruptedException iExcptn) {
                    Asserts.notReached();
                }
            }
        }
    }

    private void exceptionRaised(RaiseException exception) {
        Asserts.isTrue(Thread.currentThread() == this.jvmThread);
        if (this.abortOnException()) {
            this.runtime.getMainContext().getCurrentThread().raise(RubyException.newException(this.getRuntime(), this.getRuntime().getExceptions().getSystemExit(), ""));
        } else {
            this.exitingException = exception;
        }
    }

    private boolean abortOnException() {
        return globalAbortOnException || this.abortOnException;
    }

    public static ThreadClass mainThread(IRubyObject receiver) {
        return receiver.getRuntime().getMainContext().getCurrentThread();
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 61443: {
                return this.abort_on_exception();
            }
            case 61444: {
                return this.abort_on_exception_set(args[0]);
            }
            case 61441: {
                return this.aref(args[0]);
            }
            case 61442: {
                return this.aset(args[0], args[1]);
            }
            case 61448: {
                return this.has_key(args[0]);
            }
            case 61445: {
                return this.is_alive();
            }
            case 61447: {
                return this.join();
            }
            case 61449: {
                return this.priority();
            }
            case 61450: {
                return this.priority_set(args[0]);
            }
            case 61451: {
                return this.raise(args[0]);
            }
            case 61452: {
                return this.status();
            }
        }
        return super.callIndexed(index, args);
    }
}

