/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.MetaClass;
import org.jruby.Method;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.IndexedCallback;
import org.jruby.runtime.builtin.IRubyObject;

public class UnboundMethod
extends Method {
    private static final int BIND = 65616;
    private static final int CALL = 65617;
    private static final int TO_PROC = 65618;
    private static final int UNBIND = 65619;

    protected UnboundMethod(Ruby runtime) {
        super(runtime, runtime.getClasses().getUnboundMethodClass());
    }

    public static UnboundMethod newUnboundMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, ICallable method) {
        Ruby runtime = implementationModule.getRuntime();
        UnboundMethod newMethod = new UnboundMethod(runtime);
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method;
        return newMethod;
    }

    public static RubyClass defineUnboundMethodClass(Ruby runtime) {
        RubyClass newClass = runtime.defineClass("UnboundMethod", runtime.getClasses().getMethodClass());
        newClass.defineMethod("[]", IndexedCallback.createOptional(65617));
        newClass.defineMethod("bind", IndexedCallback.create(65616, 1));
        newClass.defineMethod("call", IndexedCallback.createOptional(65617));
        newClass.defineMethod("to_proc", IndexedCallback.create(65618, 0));
        newClass.defineMethod("unbind", IndexedCallback.create(65619, 0));
        return newClass;
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 65616: {
                return this.bind(args[0]);
            }
            case 65617: {
                return this.call(args);
            }
            case 65618: {
                return this.to_proc();
            }
            case 65619: {
                return this.unbind();
            }
        }
        return super.callIndexed(index, args);
    }

    public IRubyObject call(IRubyObject[] args) {
        throw new TypeError(this.runtime, "you cannot call unbound method; bind first");
    }

    public IRubyObject to_proc() {
        return super.to_proc();
    }

    public UnboundMethod unbind() {
        return this;
    }

    public Method bind(IRubyObject receiver) {
        RubyClass receiverClass = receiver.getMetaClass();
        if (this.originModule != receiverClass) {
            if (this.originModule instanceof MetaClass) {
                throw new TypeError(this.runtime, "singleton method called for a different object");
            }
            if (receiverClass instanceof MetaClass && receiverClass.getMethods().containsKey(this.originName)) {
                throw new TypeError(this.runtime, "method `" + this.originName + "' overridden");
            }
            if (!(!this.originModule.isModule() ? receiver.getType() == this.originModule : receiver.isKindOf(this.originModule))) {
                throw new TypeError(this.runtime, "bind argument must be an instance of " + this.originModule.toName());
            }
        }
        return Method.newMethod(this.implementationModule, this.methodName, receiverClass, this.originName, this.method, receiver);
    }
}

