/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.visitor;

import org.ablaf.ast.INode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.util.ListNodeUtil;
import org.jruby.ast.visitor.AbstractVisitor;

public class ExpressionVisitor
extends AbstractVisitor {
    private boolean expression = false;

    public boolean isExpression(INode node) {
        this.acceptNode(node);
        return this.isExpression();
    }

    public boolean isExpression() {
        return this.expression;
    }

    public void setExpression(boolean expression) {
        this.expression = expression;
    }

    protected void visitNode(INode iVisited) {
        this.expression = true;
    }

    public void visitBeginNode(BeginNode iVisited) {
        this.acceptNode(iVisited.getBodyNode());
    }

    public void visitBlockNode(BlockNode iVisited) {
        this.acceptNode(ListNodeUtil.getLast(iVisited));
    }

    public void visitBreakNode(BreakNode iVisited) {
        this.expression = false;
    }

    public void visitClassNode(ClassNode iVisited) {
        this.expression = false;
    }

    public void visitDefnNode(DefnNode iVisited) {
        this.expression = false;
    }

    public void visitDefsNode(DefsNode iVisited) {
        this.expression = false;
    }

    public void visitIfNode(IfNode iVisited) {
        this.expression = this.isExpression(iVisited.getThenBody()) && this.isExpression(iVisited.getElseBody());
    }

    public void visitModuleNode(ModuleNode iVisited) {
        this.expression = false;
    }

    public void visitNewlineNode(NewlineNode iVisited) {
        this.acceptNode(iVisited.getNextNode());
    }

    public void visitNextNode(NextNode iVisited) {
        this.expression = false;
    }

    public void visitRedoNode(RedoNode iVisited) {
        this.expression = false;
    }

    public void visitRetryNode(RetryNode iVisited) {
        this.expression = false;
    }

    public void visitReturnNode(ReturnNode iVisited) {
        this.expression = false;
    }

    public void visitUntilNode(UntilNode iVisited) {
        this.expression = false;
    }

    public void visitWhileNode(WhileNode iVisited) {
        this.expression = false;
    }
}

