/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import org.ablaf.ast.INode;
import org.ablaf.common.IErrorHandler;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.util.ListNodeUtil;
import org.jruby.ast.visitor.AbstractVisitor;
import org.jruby.evaluator.EvaluateVisitor;
import org.jruby.exceptions.ArgumentError;
import org.jruby.runtime.CallType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public class AssignmentVisitor
extends AbstractVisitor {
    private Ruby ruby;
    private IRubyObject self;
    private IErrorHandler errorHandler;
    private IRubyObject value;
    private boolean check;
    private IRubyObject result;

    public AssignmentVisitor(Ruby ruby, IRubyObject self) {
        this.ruby = ruby;
        this.self = self;
    }

    public IRubyObject assign(INode node, IRubyObject value, boolean check) {
        this.value = value;
        this.check = check;
        this.acceptNode(node);
        return this.result;
    }

    protected void visitNode(INode iVisited) {
        Asserts.notReached();
    }

    public void visitCallNode(CallNode iVisited) {
        EvaluateVisitor evaluator = EvaluateVisitor.createVisitor(this.self);
        IRubyObject receiver = evaluator.eval(iVisited.getReceiverNode());
        if (iVisited.getArgsNode() == null) {
            receiver.getMetaClass().call(receiver, iVisited.getName(), new IRubyObject[]{this.value}, CallType.NORMAL);
        } else {
            RubyArray args = (RubyArray)evaluator.eval(iVisited.getArgsNode());
            args.append(this.value);
            receiver.getMetaClass().call(receiver, iVisited.getName(), args.toJavaArray(), CallType.NORMAL);
        }
    }

    public void visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
        this.ruby.getCBase().setClassVar(iVisited.getName(), this.value);
    }

    public void visitClassVarDeclNode(ClassVarDeclNode iVisited) {
        if (this.ruby.isVerbose() && this.ruby.getCBase().isSingleton()) {
            this.errorHandler.handleError(1, "Declaring singleton class variable.");
        }
        this.ruby.getCBase().declareClassVar(iVisited.getName(), this.value);
    }

    public void visitConstDeclNode(ConstDeclNode iVisited) {
        this.ruby.getRubyClass().defineConstant(iVisited.getName(), this.value);
    }

    public void visitDAsgnNode(DAsgnNode iVisited) {
        this.ruby.setDynamicVariable(iVisited.getName(), this.value);
    }

    public void visitGlobalAsgnNode(GlobalAsgnNode iVisited) {
        this.ruby.getGlobalVariables().set(iVisited.getName(), this.value);
    }

    public void visitInstAsgnNode(InstAsgnNode iVisited) {
        this.self.setInstanceVariable(iVisited.getName(), this.value);
    }

    public void visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.ruby.getScope().setValue(iVisited.getCount(), this.value);
    }

    /*
     * Unable to fully structure code
     */
    public void visitMultipleAsgnNode(MultipleAsgnNode iVisited) {
        block10: {
            if (this.value == null) {
                this.value = RubyArray.newArray(this.ruby, 0L);
            } else if (!(this.value instanceof RubyArray)) {
                newValue = this.value.convertToType("Array", "to_ary", false);
                if (newValue.isNil()) {
                    newValue = RubyArray.newArray(this.ruby, this.value);
                }
                this.value = newValue;
            }
            valueLen = ((RubyArray)this.value).getLength();
            varLen = ListNodeUtil.getLength(iVisited.getHeadNode());
            iter = iVisited.getHeadNode() != null ? iVisited.getHeadNode().iterator() : Collections.EMPTY_LIST.iterator();
            i = 0;
            while (i < valueLen && iter.hasNext()) {
                new AssignmentVisitor(this.ruby, this.self).assign((INode)iter.next(), ((RubyArray)this.value).entry(i), this.check);
                ++i;
            }
            if (this.check && varLen > valueLen) {
                throw new ArgumentError(this.ruby, "Wrong # of arguments (" + valueLen + " for " + varLen + ")");
            }
            if (iVisited.getArgsNode() == null) break block10;
            if (!(iVisited.getArgsNode() instanceof StarNode)) {
                if (varLen < valueLen) {
                    newList = new ArrayList<E>(((RubyArray)this.value).getList().subList(varLen, valueLen));
                    new AssignmentVisitor(this.ruby, this.self).assign(iVisited.getArgsNode(), RubyArray.newArray(this.ruby, newList), this.check);
                } else {
                    new AssignmentVisitor(this.ruby, this.self).assign(iVisited.getArgsNode(), RubyArray.newArray(this.ruby, 0L), this.check);
                }
            }
            ** GOTO lbl35
        }
        if (!this.check || valueLen >= varLen) ** GOTO lbl35
        throw new ArgumentError(this.ruby, "Wrong # of arguments (" + valueLen + " for " + varLen + ")");
lbl-1000:
        // 1 sources

        {
            new AssignmentVisitor(this.ruby, this.self).assign((INode)iter.next(), this.ruby.getNil(), this.check);
lbl35:
            // 4 sources

            ** while (iter.hasNext())
        }
lbl36:
        // 1 sources

        this.result = this.value;
    }
}

