/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import java.util.Iterator;
import org.ablaf.ast.INode;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrSetNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.visitor.AbstractVisitor;
import org.jruby.evaluator.EvaluateVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class DefinedVisitor
extends AbstractVisitor {
    private Ruby ruby;
    private IRubyObject self;
    private String definition;

    public DefinedVisitor(Ruby ruby, IRubyObject self) {
        this.ruby = ruby;
        this.self = self;
    }

    public String getDefinition(INode expression) {
        this.definition = null;
        this.acceptNode(expression);
        return this.definition;
    }

    public String getArgumentDefinition(INode node, String type) {
        if (node == null) {
            return type;
        }
        if (node instanceof ArrayNode) {
            Iterator iter = ((ArrayNode)node).iterator();
            while (iter.hasNext()) {
                if (this.getDefinition((INode)iter.next()) != null) continue;
                return null;
            }
        } else if (this.getDefinition(node) == null) {
            return null;
        }
        return type;
    }

    protected void visitNode(INode iVisited) {
        try {
            EvaluateVisitor.createVisitor(this.self).eval(iVisited);
            this.definition = "expression";
        }
        catch (JumpException jumpExcptn) {}
    }

    public void visitSuperNode(SuperNode iVisited) {
        String lastMethod = this.ruby.getCurrentFrame().getLastFunc();
        RubyModule lastClass = this.ruby.getCurrentFrame().getLastClass();
        if (lastMethod != null && lastClass != null && lastClass.getSuperClass().isMethodBound(lastMethod, false)) {
            this.definition = this.getArgumentDefinition(iVisited.getArgsNode(), "super");
        }
    }

    public void visitZSuperNode(ZSuperNode iVisited) {
        String lastMethod = this.ruby.getCurrentFrame().getLastFunc();
        RubyModule lastClass = this.ruby.getCurrentFrame().getLastClass();
        if (lastMethod != null && lastClass != null && lastClass.getSuperClass().isMethodBound(lastMethod, false)) {
            this.definition = "super";
        }
    }

    public void visitCallNode(CallNode iVisited) {
        if (this.getDefinition(iVisited.getReceiverNode()) != null) {
            try {
                IRubyObject receiver = EvaluateVisitor.createVisitor(this.self).eval(iVisited.getReceiverNode());
                Visibility visibility = receiver.getMetaClass().getMethodVisibility(iVisited.getName());
                if (!visibility.isPrivate() && (!visibility.isProtected() || this.self.isKindOf(receiver.getMetaClass().getRealClass())) && receiver.getMetaClass().isMethodBound(iVisited.getName(), false)) {
                    this.definition = this.getArgumentDefinition(iVisited.getArgsNode(), "method");
                    return;
                }
            }
            catch (JumpException excptn) {
                // empty catch block
            }
        }
        this.definition = null;
    }

    public void visitFCallNode(FCallNode iVisited) {
        if (this.self.getMetaClass().isMethodBound(iVisited.getName(), false)) {
            this.definition = this.getArgumentDefinition(iVisited.getArgsNode(), "method");
        }
    }

    public void visitVCallNode(VCallNode iVisited) {
        if (this.self.getMetaClass().isMethodBound(iVisited.getMethodName(), false)) {
            this.definition = "method";
        }
    }

    public void visitMatch2Node(Match2Node iVisited) {
        this.definition = "method";
    }

    public void visitMatch3Node(Match3Node iVisited) {
        this.definition = "method";
    }

    public void visitFalseNode(FalseNode iVisited) {
        this.definition = "false";
    }

    public void visitNilNode(NilNode iVisited) {
        this.definition = "nil";
    }

    public void visitNullNode() {
        this.definition = "expression";
    }

    public void visitSelfNode(SelfNode iVisited) {
        this.definition = "self";
    }

    public void visitTrueNode(TrueNode iVisited) {
        this.definition = "true";
    }

    public void visitYieldNode(YieldNode iVisited) {
        if (this.ruby.isBlockGiven()) {
            this.definition = "yield";
        }
    }

    public void visitAttrSetNode(AttrSetNode iVisited) {
        this.definition = "assignment";
    }

    public void visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
        this.definition = "assignment";
    }

    public void visitClassVarDeclNode(ClassVarDeclNode iVisited) {
        this.definition = "assignment";
    }

    public void visitConstDeclNode(ConstDeclNode iVisited) {
        this.definition = "assignment";
    }

    public void visitDAsgnNode(DAsgnNode iVisited) {
        this.definition = "assignment";
    }

    public void visitGlobalAsgnNode(GlobalAsgnNode iVisited) {
        this.definition = "assignment";
    }

    public void visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.definition = "assignment";
    }

    public void visitMultipleAsgnNode(MultipleAsgnNode iVisited) {
        this.definition = "assignment";
    }

    public void visitOpAsgnNode(OpAsgnNode iVisited) {
        this.definition = "assignment";
    }

    public void visitOpElementAsgnNode(OpElementAsgnNode iVisited) {
        this.definition = "assignment";
    }

    public void visitDVarNode(DVarNode iVisited) {
        this.definition = "local-variable(in-block)";
    }

    public void visitLocalVarNode(LocalVarNode iVisited) {
        this.definition = "local-variable";
    }

    public void visitClassVarNode(ClassVarNode iVisited) {
        if (this.ruby.getCBase() == null && this.self.getMetaClass().isClassVarDefined(iVisited.getName())) {
            this.definition = "class_variable";
        } else if (!this.ruby.getCBase().isSingleton() && this.ruby.getCBase().isClassVarDefined(iVisited.getName())) {
            this.definition = "class_variable";
        } else if (((RubyModule)this.ruby.getCBase().getInstanceVariable("__attached__")).isClassVarDefined(iVisited.getName())) {
            this.definition = "class_variable";
        }
    }

    public void visitConstNode(ConstNode iVisited) {
        this.definition = "constant";
    }

    public void visitGlobalVarNode(GlobalVarNode iVisited) {
        if (this.ruby.getGlobalVariables().isDefined(iVisited.getName())) {
            this.definition = "global-variable";
        }
    }

    public void visitInstVarNode(InstVarNode iVisited) {
        if (this.self.hasInstanceVariable(iVisited.getName())) {
            this.definition = "instance-variable";
        }
    }

    public void visitColon2Node(Colon2Node iVisited) {
        block4: {
            try {
                IRubyObject left = EvaluateVisitor.createVisitor(this.self).eval(iVisited.getLeftNode());
                if (left instanceof RubyModule) {
                    if (!((RubyModule)left).isConstantDefinedAt(iVisited.getName())) break block4;
                    this.definition = "constant";
                    break block4;
                }
                if (left.getMetaClass().isMethodBound(iVisited.getName(), true)) {
                    this.definition = "method";
                }
            }
            catch (JumpException excptn) {}
        }
    }

    public void visitBackRefNode(BackRefNode iVisited) {
        this.definition = "$" + iVisited.getType();
    }

    public void visitNthRefNode(NthRefNode iVisited) {
        this.definition = "$" + iVisited.getMatchNumber();
    }
}

