/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import java.util.ArrayList;
import java.util.Iterator;
import org.ablaf.ast.INode;
import org.ablaf.common.ISourcePosition;
import org.jruby.Builtins;
import org.jruby.KernelModule;
import org.jruby.MetaClass;
import org.jruby.Method;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrSetNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.ExpandArrayNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OptNNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.RestArgsNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.ScopeNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZArrayNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.IListNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.DefinedVisitor;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.BreakJump;
import org.jruby.exceptions.FrozenError;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.NextJump;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RedoJump;
import org.jruby.exceptions.RetryJump;
import org.jruby.exceptions.ReturnJump;
import org.jruby.exceptions.SecurityError;
import org.jruby.exceptions.TypeError;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.EvaluateMethod;
import org.jruby.internal.runtime.methods.WrapperCallable;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public final class EvaluateVisitor
implements NodeVisitor {
    private Ruby runtime;
    private ThreadContext threadContext;
    private Builtins builtins;
    private IRubyObject self;
    private IRubyObject result;

    public EvaluateVisitor(Ruby ruby, IRubyObject self) {
        this.runtime = ruby;
        this.threadContext = this.runtime.getCurrentContext();
        this.self = self;
        this.builtins = new Builtins(ruby);
    }

    public static EvaluateVisitor createVisitor(IRubyObject self) {
        Ruby ruby = self.getRuntime();
        return new EvaluateVisitor(ruby, self);
    }

    private boolean isTrace() {
        return this.runtime.getTraceFunction() != null;
    }

    private void callTraceFunction(String event, IRubyObject self) {
        String name = this.threadContext.getCurrentFrame().getLastFunc();
        RubyModule type = this.threadContext.getCurrentFrame().getLastClass();
        this.runtime.callTraceFunction(event, this.threadContext.getPosition(), self, name, type);
    }

    public IRubyObject eval(INode node) {
        this.threadContext.pollThreadEvents();
        this.result = this.runtime.getNil();
        if (node != null) {
            node.accept(this);
        }
        return this.result;
    }

    public void visitAliasNode(AliasNode iVisited) {
        if (this.runtime.getRubyClass() == null) {
            throw new TypeError(this.runtime, "no class to make alias");
        }
        this.runtime.getRubyClass().aliasMethod(iVisited.getNewName(), iVisited.getOldName());
        this.runtime.getRubyClass().callMethod("method_added", this.builtins.toSymbol(iVisited.getNewName()));
    }

    public void visitAndNode(AndNode iVisited) {
        if (this.eval(iVisited.getFirstNode()).isTrue()) {
            this.eval(iVisited.getSecondNode());
        }
    }

    public void visitArgsNode(ArgsNode iVisited) {
        Asserts.notReached();
    }

    public void visitArrayNode(ArrayNode iVisited) {
        ArrayList<IRubyObject> list = new ArrayList<IRubyObject>(iVisited.size());
        Iterator iterator = iVisited.iterator();
        int i = 0;
        int size = iVisited.size();
        while (i < size) {
            INode node = (INode)iterator.next();
            if (node instanceof ExpandArrayNode) {
                list.addAll(((RubyArray)this.eval(node)).getList());
            } else {
                list.add(this.eval(node));
            }
            ++i;
        }
        this.result = RubyArray.newArray(this.runtime, list);
    }

    public void visitAttrSetNode(AttrSetNode iVisited) {
        if (this.runtime.getCurrentFrame().getArgs().length != 1) {
            throw new ArgumentError(this.runtime, "wrong # of arguments(" + this.threadContext.getCurrentFrame().getArgs().length + "for 1)");
        }
        this.result = this.self.setInstanceVariable(iVisited.getAttributeName(), this.threadContext.getCurrentFrame().getArgs()[0]);
    }

    public void visitBackRefNode(BackRefNode iVisited) {
        IRubyObject backref = this.threadContext.getBackref();
        switch (iVisited.getType()) {
            case '&': {
                this.result = RubyRegexp.last_match(backref);
                break;
            }
            case '`': {
                this.result = RubyRegexp.match_pre(backref);
                break;
            }
            case '\'': {
                this.result = RubyRegexp.match_post(backref);
                break;
            }
            case '+': {
                this.result = RubyRegexp.match_last(backref);
            }
        }
    }

    public void visitBeginNode(BeginNode iVisited) {
        this.eval(iVisited.getBodyNode());
    }

    public void visitBlockArgNode(BlockArgNode iVisited) {
        Asserts.notReached();
    }

    public void visitBlockNode(BlockNode iVisited) {
        Iterator iter = iVisited.iterator();
        while (iter.hasNext()) {
            this.eval((INode)iter.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitBlockPassNode(BlockPassNode iVisited) {
        IRubyObject block = this.eval(iVisited.getBodyNode());
        if (block.isNil()) {
            this.threadContext.getIterStack().push(Iter.ITER_NOT);
            try {
                this.eval(iVisited.getIterNode());
                Object var4_3 = null;
                this.threadContext.getIterStack().pop();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.threadContext.getIterStack().pop();
                throw throwable;
            }
            return;
        }
        if (block instanceof Method) {
            block = ((Method)block).to_proc();
        } else if (!(block instanceof RubyProc)) {
            throw new TypeError(this.runtime, "wrong argument type " + block.getMetaClass().toName() + " (expected Proc)");
        }
        Block oldBlock = this.threadContext.getBlockStack().getCurrent();
        this.threadContext.getBlockStack().push(((RubyProc)block).getBlock());
        this.threadContext.getIterStack().push(Iter.ITER_PRE);
        this.threadContext.getCurrentFrame().setIter(Iter.ITER_PRE);
        try {
            this.eval(iVisited.getIterNode());
            Object var6_7 = null;
            this.threadContext.getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.threadContext.getIterStack().pop();
            this.threadContext.getBlockStack().setCurrent(oldBlock);
            throw throwable;
        }
        this.threadContext.getBlockStack().setCurrent(oldBlock);
    }

    public void visitBreakNode(BreakNode iVisited) {
        throw new BreakJump();
    }

    public void visitConstDeclNode(ConstDeclNode iVisited) {
        if (this.runtime.getRubyClass() == null) {
            throw new TypeError(this.runtime, "no class/module to define constant");
        }
        this.runtime.getRubyClass().setConstant(iVisited.getName(), this.eval(iVisited.getValueNode()));
    }

    public void visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
        this.eval(iVisited.getValueNode());
        this.runtime.getCBase().setClassVar(iVisited.getName(), this.result);
    }

    public void visitClassVarDeclNode(ClassVarDeclNode iVisited) {
        if (this.threadContext.getCBase() == null) {
            throw new TypeError(this.runtime, "no class/module to define class variable");
        }
        this.eval(iVisited.getValueNode());
        this.threadContext.getCBase().declareClassVar(iVisited.getName(), this.result);
    }

    public void visitClassVarNode(ClassVarNode iVisited) {
        this.result = this.threadContext.getCBase() == null ? this.self.getMetaClass().getClassVar(iVisited.getName()) : (!this.threadContext.getCBase().isSingleton() ? this.threadContext.getCBase().getClassVar(iVisited.getName()) : ((RubyModule)this.threadContext.getCBase().getInstanceVariable("__attached__")).getClassVar(iVisited.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCallNode(CallNode iVisited) {
        Block tmpBlock = ArgsUtil.beginCallArgs(this.runtime);
        IRubyObject receiver = null;
        IRubyObject[] args = null;
        try {
            receiver = this.eval(iVisited.getReceiverNode());
            args = ArgsUtil.setupArgs(this.runtime, this, iVisited.getArgsNode());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ArgsUtil.endCallArgs(this.runtime, tmpBlock);
            throw throwable;
        }
        ArgsUtil.endCallArgs(this.runtime, tmpBlock);
        Asserts.notNull(receiver.getMetaClass(), receiver.getClass().getName());
        this.result = receiver.getMetaClass().call(receiver, iVisited.getName(), args, CallType.NORMAL);
    }

    public void visitCaseNode(CaseNode iVisited) {
        if (iVisited.getCaseNode() != null) {
            IRubyObject expression = this.eval(iVisited.getCaseNode());
            Iterator iter = iVisited.getWhenNodes().iterator();
            int i = 0;
            int size = iVisited.getWhenNodes().size();
            while (i < size) {
                WhenNode whenNode = (WhenNode)iter.next();
                this.threadContext.setPosition(whenNode.getPosition());
                if (this.isTrace()) {
                    this.callTraceFunction("line", this.self);
                }
                RubyArray expressions = (RubyArray)this.eval(whenNode.getExpressionNodes());
                int j = 0;
                int len = expressions.getLength();
                while (j < len) {
                    if (expressions.entry(j).callMethod("===", expression).isTrue()) {
                        this.eval(whenNode);
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            Iterator iter = iVisited.getWhenNodes().iterator();
            while (iter.hasNext()) {
                WhenNode whenNode = (WhenNode)iter.next();
                this.threadContext.setPosition(whenNode.getPosition());
                if (this.isTrace()) {
                    this.callTraceFunction("line", this.self);
                }
                RubyArray expressions = (RubyArray)this.eval(whenNode.getExpressionNodes());
                int i = 0;
                while (i < expressions.getLength()) {
                    if (expressions.entry(i).isTrue()) {
                        this.eval(whenNode);
                        return;
                    }
                    ++i;
                }
            }
        }
        this.eval(iVisited.getElseNode());
    }

    public void visitClassNode(ClassNode iVisited) {
        if (this.runtime.getRubyClass().isNil()) {
            throw new TypeError(this.runtime, "no outer class/module");
        }
        RubyClass superClass = null;
        if (iVisited.getSuperNode() != null) {
            try {
                superClass = (RubyClass)this.eval(iVisited.getSuperNode());
            }
            catch (Exception excptn) {
                if (iVisited.getSuperNode() instanceof Colon2Node) {
                    throw new TypeError(this.runtime, "undefined superclass '" + ((Colon2Node)iVisited.getSuperNode()).getName() + "'");
                }
                if (iVisited.getSuperNode() instanceof ConstNode) {
                    throw new TypeError(this.runtime, "undefined superclass '" + ((ConstNode)iVisited.getSuperNode()).getName() + "'");
                }
                throw new TypeError(this.runtime, "undefined superclass");
            }
            if (superClass != null && superClass instanceof MetaClass) {
                throw new TypeError(this.runtime, "can't make subclass of virtual class");
            }
        }
        RubyClass rubyClass = null;
        if (this.runtime.getRubyClass().isConstantDefined(iVisited.getClassName())) {
            IRubyObject type = this.runtime.getRubyClass().getConstant(iVisited.getClassName());
            if (!(type instanceof RubyClass)) {
                throw new TypeError(this.runtime, iVisited.getClassName() + " is not a class");
            }
            rubyClass = (RubyClass)type;
            if (superClass != null && rubyClass.getSuperClass().getRealClass() != superClass) {
                rubyClass = this.runtime.defineClass(iVisited.getClassName(), superClass);
                rubyClass.setClassPath(this.runtime.getRubyClass(), iVisited.getClassName());
                this.runtime.getRubyClass().setConstant(iVisited.getClassName(), rubyClass);
            } else if (this.runtime.getSafeLevel() >= 4) {
                throw new SecurityError(this.runtime, "extending class prohibited");
            }
        } else {
            if (superClass == null) {
                superClass = this.runtime.getClasses().getObjectClass();
            }
            rubyClass = this.runtime.defineClass(iVisited.getClassName(), superClass);
            this.runtime.getRubyClass().setConstant(iVisited.getClassName(), rubyClass);
            rubyClass.setClassPath(this.runtime.getRubyClass(), iVisited.getClassName());
        }
        if (this.runtime.getWrapper() != null) {
            rubyClass.extendObject(this.runtime.getWrapper());
            rubyClass.includeModule(this.runtime.getWrapper());
        }
        this.evalClassDefinitionBody(iVisited.getBodyNode(), rubyClass);
    }

    public void visitColon2Node(Colon2Node iVisited) {
        this.eval(iVisited.getLeftNode());
        this.result = this.result instanceof RubyModule ? ((RubyModule)this.result).getConstant(iVisited.getName()) : this.result.callMethod(iVisited.getName());
    }

    public void visitColon3Node(Colon3Node iVisited) {
        this.result = this.runtime.getClasses().getObjectClass().getConstant(iVisited.getName());
    }

    public void visitConstNode(ConstNode iVisited) {
        this.result = this.threadContext.getCurrentFrame().getNamespace().getConstant(this.self, iVisited.getName());
    }

    public void visitDAsgnNode(DAsgnNode iVisited) {
        this.eval(iVisited.getValueNode());
        this.runtime.setDynamicVariable(iVisited.getName(), this.result);
    }

    public void visitDRegxNode(DRegexpNode iVisited) {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = iVisited.iterator();
        while (iterator.hasNext()) {
            INode node = (INode)iterator.next();
            sb.append(this.eval(node));
        }
        this.result = RubyRegexp.newRegexp(this.runtime, sb.toString(), iVisited.getOptions());
    }

    public final void visitDStrNode(DStrNode iVisited) {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = iVisited.iterator();
        while (iterator.hasNext()) {
            INode node = (INode)iterator.next();
            sb.append(this.eval(node));
        }
        this.result = this.builtins.toString(sb.toString());
    }

    public void visitDVarNode(DVarNode iVisited) {
        this.result = this.runtime.getDynamicValue(iVisited.getName());
    }

    public void visitDXStrNode(DXStrNode iVisited) {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = iVisited.iterator();
        while (iterator.hasNext()) {
            INode node = (INode)iterator.next();
            sb.append(this.eval(node));
        }
        this.result = this.self.callMethod("`", this.builtins.toString(sb.toString()));
    }

    public void visitDefinedNode(DefinedNode iVisited) {
        String def = new DefinedVisitor(this.runtime, this.self).getDefinition(iVisited.getExpressionNode());
        if (def != null) {
            this.result = this.builtins.toString(def);
        }
    }

    public void visitDefnNode(DefnNode iVisited) {
        RubyModule rubyClass = this.runtime.getRubyClass();
        if (rubyClass == null) {
            throw new TypeError(this.runtime, "No class to add method.");
        }
        String name = iVisited.getName();
        if (rubyClass == this.runtime.getClasses().getObjectClass() && name.equals("initialize")) {
            this.runtime.getErrorHandler().warn("redefining Object#initialize may cause infinite loop");
        } else if (name.equals("__id__") || name.equals("__send__")) {
            this.runtime.getErrorHandler().warn("redefining '" + name + "' may cause serious problem");
        }
        Visibility visibility = this.threadContext.getCurrentVisibility();
        if (name.equals("initialize") || visibility.isModuleFunction()) {
            visibility = Visibility.PRIVATE;
        } else if (visibility.isPublic() && rubyClass == this.runtime.getClasses().getObjectClass()) {
            visibility = iVisited.getVisibility();
        }
        DefaultMethod newMethod = new DefaultMethod(iVisited.getBodyNode(), (ArgsNode)iVisited.getArgsNode(), this.runtime.getNamespace(), visibility);
        rubyClass.addMethod(name, newMethod);
        if (this.threadContext.getCurrentVisibility().isModuleFunction()) {
            rubyClass.getSingletonClass().addMethod(name, new WrapperCallable(newMethod, Visibility.PUBLIC));
            rubyClass.callMethod("singleton_method_added", this.builtins.toSymbol(name));
        }
        rubyClass.methodAdded(this.builtins.toSymbol(name));
    }

    public void visitDefsNode(DefsNode iVisited) {
        IRubyObject receiver = this.eval(iVisited.getReceiverNode());
        if (this.runtime.getSafeLevel() >= 4 && !receiver.isTaint()) {
            throw new SecurityError(this.runtime, "Insecure; can't define singleton method.");
        }
        if (receiver.isFrozen()) {
            throw new FrozenError(this.runtime, "object");
        }
        RubyClass rubyClass = receiver.getSingletonClass();
        ICallable method = (ICallable)rubyClass.getMethods().get(iVisited.getName());
        if (method != null && this.runtime.getSafeLevel() >= 4) {
            throw new SecurityError(this.runtime, "Redefining method prohibited.");
        }
        DefaultMethod newMethod = new DefaultMethod(iVisited.getBodyNode(), (ArgsNode)iVisited.getArgsNode(), this.runtime.getNamespace(), Visibility.PUBLIC);
        rubyClass.addMethod(iVisited.getName(), newMethod);
        receiver.callMethod("singleton_method_added", this.builtins.toSymbol(iVisited.getName()));
        this.result = this.runtime.getNil();
    }

    public void visitDotNode(DotNode iVisited) {
        this.result = RubyRange.newRange(this.runtime, this.eval(iVisited.getBeginNode()), this.eval(iVisited.getEndNode()), iVisited.isExclusive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitEnsureNode(EnsureNode iVisited) {
        try {
            this.result = this.eval(iVisited.getBodyNode());
        }
        finally {
            if (iVisited.getEnsureNode() != null) {
                IRubyObject oldResult = this.result;
                this.eval(iVisited.getEnsureNode());
                this.result = oldResult;
            }
        }
    }

    public final void visitEvStrNode(EvStrNode iVisited) {
        if (iVisited.getEvaluatedNode() == null) {
            INode node = this.runtime.getParser().parse("#{}", iVisited.getValue(), this.threadContext.getDynamicNames());
            iVisited.setEvaluatedNode(node);
        }
        this.eval(iVisited.getEvaluatedNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitFCallNode(FCallNode iVisited) {
        Block tmpBlock = ArgsUtil.beginCallArgs(this.runtime);
        IRubyObject[] args = null;
        try {
            args = ArgsUtil.setupArgs(this.runtime, this, iVisited.getArgsNode());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ArgsUtil.endCallArgs(this.runtime, tmpBlock);
            throw throwable;
        }
        ArgsUtil.endCallArgs(this.runtime, tmpBlock);
        this.result = this.self.getMetaClass().call(this.self, iVisited.getName(), args, CallType.FUNCTIONAL);
    }

    public void visitFalseNode(FalseNode iVisited) {
        this.result = this.runtime.getFalse();
    }

    public void visitFlipNode(FlipNode iVisited) {
        if (iVisited.isExclusive()) {
            if (!this.threadContext.getScopeStack().getValue(iVisited.getCount()).isTrue()) {
                this.result = this.eval(iVisited.getBeginNode()).isTrue() ? this.runtime.getFalse() : this.runtime.getTrue();
                this.threadContext.getScopeStack().setValue(iVisited.getCount(), this.result);
            } else {
                if (this.eval(iVisited.getEndNode()).isTrue()) {
                    this.threadContext.getScopeStack().setValue(iVisited.getCount(), this.runtime.getFalse());
                }
                this.result = this.runtime.getTrue();
            }
        } else if (!this.threadContext.getScopeStack().getValue(iVisited.getCount()).isTrue()) {
            if (this.eval(iVisited.getBeginNode()).isTrue()) {
                this.threadContext.getScopeStack().setValue(iVisited.getCount(), this.eval(iVisited.getEndNode()).isTrue() ? this.runtime.getFalse() : this.runtime.getTrue());
                this.result = this.runtime.getTrue();
            } else {
                this.result = this.runtime.getFalse();
            }
        } else {
            if (this.eval(iVisited.getEndNode()).isTrue()) {
                this.runtime.getScope().setValue(iVisited.getCount(), this.runtime.getFalse());
            }
            this.result = this.runtime.getTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visitForNode(ForNode iVisited) {
        this.threadContext.getBlockStack().push(iVisited.getVarNode(), new EvaluateMethod(iVisited.getBodyNode()), this.self);
        this.threadContext.getIterStack().push(Iter.ITER_PRE);
        try {
            try {
                while (true) {
                    try {
                        ISourcePosition position = this.threadContext.getPosition();
                        Block tmpBlock = ArgsUtil.beginCallArgs(this.runtime);
                        IRubyObject recv = null;
                        try {
                            recv = this.eval(iVisited.getIterNode());
                            Object var6_7 = null;
                            this.threadContext.setPosition(position);
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            this.threadContext.setPosition(position);
                            ArgsUtil.endCallArgs(this.runtime, tmpBlock);
                            throw throwable;
                        }
                        ArgsUtil.endCallArgs(this.runtime, tmpBlock);
                        this.result = recv.getMetaClass().call(recv, "each", IRubyObject.NULL_ARRAY, CallType.NORMAL);
                    }
                    catch (RetryJump rExcptn) {
                        continue;
                    }
                    break;
                }
                Object var8_10 = null;
                this.runtime.getIterStack().pop();
                this.runtime.getBlockStack().pop();
                return;
            }
            catch (BreakJump bExcptn) {
                this.result = this.runtime.getNil();
                Object var8_11 = null;
                this.runtime.getIterStack().pop();
                this.runtime.getBlockStack().pop();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.runtime.getIterStack().pop();
            this.runtime.getBlockStack().pop();
            throw throwable;
        }
    }

    public void visitGlobalAsgnNode(GlobalAsgnNode iVisited) {
        this.eval(iVisited.getValueNode());
        this.runtime.getGlobalVariables().set(iVisited.getName(), this.result);
    }

    public void visitGlobalVarNode(GlobalVarNode iVisited) {
        this.result = this.runtime.getGlobalVariables().get(iVisited.getName());
    }

    public void visitHashNode(HashNode iVisited) {
        RubyHash hash = RubyHash.newHash(this.runtime);
        if (iVisited.getListNode() != null) {
            Iterator iterator = iVisited.getListNode().iterator();
            while (iterator.hasNext()) {
                IRubyObject key = this.eval((INode)iterator.next());
                if (iterator.hasNext()) {
                    hash.aset(key, this.eval((INode)iterator.next()));
                    continue;
                }
                throw new RuntimeException("[BUG] odd number list for Hash");
            }
        }
        this.result = hash;
    }

    public void visitInstAsgnNode(InstAsgnNode iVisited) {
        this.eval(iVisited.getValueNode());
        this.self.setInstanceVariable(iVisited.getName(), this.result);
    }

    public void visitInstVarNode(InstVarNode iVisited) {
        this.result = this.self.getInstanceVariable(iVisited.getName());
    }

    public void visitIfNode(IfNode iVisited) {
        if (this.eval(iVisited.getCondition()).isTrue()) {
            this.eval(iVisited.getThenBody());
        } else {
            this.eval(iVisited.getElseBody());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visitIterNode(IterNode iVisited) {
        this.threadContext.getBlockStack().push(iVisited.getVarNode(), new EvaluateMethod(iVisited.getBodyNode()), this.self);
        this.threadContext.getIterStack().push(Iter.ITER_PRE);
        try {
            try {
                while (true) {
                    try {
                        this.result = this.eval(iVisited.getIterNode());
                    }
                    catch (RetryJump rExcptn) {
                        continue;
                    }
                    break;
                }
                Object var4_2 = null;
                this.threadContext.getIterStack().pop();
                this.threadContext.getBlockStack().pop();
                return;
            }
            catch (BreakJump bExcptn) {
                this.result = this.runtime.getNil();
                Object var4_3 = null;
                this.threadContext.getIterStack().pop();
                this.threadContext.getBlockStack().pop();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.threadContext.getIterStack().pop();
            this.threadContext.getBlockStack().pop();
            throw throwable;
        }
    }

    public void visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.eval(iVisited.getValueNode());
        this.threadContext.getScopeStack().setValue(iVisited.getCount(), this.result);
    }

    public void visitLocalVarNode(LocalVarNode iVisited) {
        this.result = this.threadContext.getScopeStack().getValue(iVisited.getCount());
    }

    public void visitMultipleAsgnNode(MultipleAsgnNode iVisited) {
        this.result = new AssignmentVisitor(this.runtime, this.self).assign(iVisited, this.eval(iVisited.getValueNode()), false);
    }

    public void visitMatch2Node(Match2Node iVisited) {
        this.result = ((RubyRegexp)this.eval(iVisited.getReceiverNode())).match(this.eval(iVisited.getValueNode()));
    }

    public void visitMatch3Node(Match3Node iVisited) {
        IRubyObject receiver = this.eval(iVisited.getReceiverNode());
        IRubyObject value = this.eval(iVisited.getValueNode());
        this.result = value instanceof RubyString ? ((RubyRegexp)receiver).match(value) : value.callMethod("=~", receiver);
    }

    public void visitMatchNode(MatchNode iVisited) {
        this.result = ((RubyRegexp)this.eval(iVisited.getRegexpNode())).match2();
    }

    public void visitModuleNode(ModuleNode iVisited) {
        if (this.runtime.getRubyClass() == null) {
            throw new TypeError(this.runtime, "no outer class/module");
        }
        RubyModule module = null;
        if (this.runtime.getRubyClass().isConstantDefined(iVisited.getName())) {
            module = (RubyModule)this.runtime.getRubyClass().getConstant(iVisited.getName());
            if (this.runtime.getSafeLevel() >= 4) {
                throw new SecurityError(this.runtime, "Extending module prohibited.");
            }
        } else {
            module = this.runtime.defineModule(iVisited.getName());
            this.runtime.getRubyClass().setConstant(iVisited.getName(), module);
            module.setClassPath(this.runtime.getRubyClass(), iVisited.getName());
        }
        if (this.runtime.getWrapper() != null) {
            module.getSingletonClass().includeModule(this.runtime.getWrapper());
            module.includeModule(this.runtime.getWrapper());
        }
        this.evalClassDefinitionBody(iVisited.getBodyNode(), module);
    }

    public void visitNewlineNode(NewlineNode iVisited) {
        ISourcePosition position = iVisited.getPosition();
        if (position != null) {
            this.threadContext.setPosition(position);
            if (this.isTrace()) {
                this.callTraceFunction("line", this.self);
            }
        }
        this.eval(iVisited.getNextNode());
    }

    public void visitNextNode(NextNode iVisited) {
        throw new NextJump();
    }

    public void visitNilNode(NilNode iVisited) {
    }

    public void visitNotNode(NotNode iVisited) {
        this.result = this.eval(iVisited.getConditionNode()).isTrue() ? this.runtime.getFalse() : this.runtime.getTrue();
    }

    public void visitNthRefNode(NthRefNode iVisited) {
        this.result = RubyRegexp.nth_match(iVisited.getMatchNumber(), this.threadContext.getBackref());
    }

    public void visitOpElementAsgnNode(OpElementAsgnNode iVisited) {
        IRubyObject receiver = this.eval(iVisited.getReceiverNode());
        IRubyObject[] args = ArgsUtil.setupArgs(this.runtime, this, iVisited.getArgsNode());
        IRubyObject firstValue = receiver.callMethod("[]", args);
        if (iVisited.getOperatorName().equals("||")) {
            if (firstValue.isTrue()) {
                this.result = firstValue;
                return;
            }
            firstValue = this.eval(iVisited.getValueNode());
        } else if (iVisited.getOperatorName().equals("&&")) {
            if (!firstValue.isTrue()) {
                this.result = firstValue;
                return;
            }
            firstValue = this.eval(iVisited.getValueNode());
        } else {
            firstValue = firstValue.callMethod(iVisited.getOperatorName(), this.eval(iVisited.getValueNode()));
        }
        IRubyObject[] expandedArgs = new IRubyObject[args.length + 1];
        System.arraycopy(args, 0, expandedArgs, 0, args.length);
        expandedArgs[expandedArgs.length - 1] = firstValue;
        this.result = receiver.callMethod("[]=", expandedArgs);
    }

    public void visitOpAsgnNode(OpAsgnNode iVisited) {
        IRubyObject receiver = this.eval(iVisited.getReceiverNode());
        IRubyObject value = receiver.callMethod(iVisited.getVariableName());
        if (iVisited.getOperatorName().equals("||")) {
            if (value.isTrue()) {
                this.result = value;
                return;
            }
            value = this.eval(iVisited.getValueNode());
        } else if (iVisited.getOperatorName().equals("&&")) {
            if (!value.isTrue()) {
                this.result = value;
                return;
            }
            value = this.eval(iVisited.getValueNode());
        } else {
            value = value.callMethod(iVisited.getOperatorName(), this.eval(iVisited.getValueNode()));
        }
        receiver.callMethod(iVisited.getVariableName() + "=", value);
        this.result = value;
    }

    public void visitOpAsgnAndNode(OpAsgnAndNode iVisited) {
        if (this.eval(iVisited.getFirstNode()).isTrue()) {
            this.eval(iVisited.getSecondNode());
        }
    }

    public void visitOpAsgnOrNode(OpAsgnOrNode iVisited) {
        if (!this.eval(iVisited.getFirstNode()).isTrue()) {
            this.eval(iVisited.getSecondNode());
        }
    }

    public void visitOptNNode(OptNNode iVisited) {
        block4: while (KernelModule.gets(this.runtime.getTopSelf(), IRubyObject.NULL_ARRAY).isTrue()) {
            while (true) {
                try {
                    this.eval(iVisited.getBodyNode());
                    continue block4;
                }
                catch (RedoJump rJump) {
                    continue;
                }
                catch (NextJump nJump) {
                    continue block4;
                }
                catch (BreakJump bJump) {
                    return;
                }
                break;
            }
        }
    }

    public void visitOrNode(OrNode iVisited) {
        if (!this.eval(iVisited.getFirstNode()).isTrue()) {
            this.eval(iVisited.getSecondNode());
        }
    }

    public void visitPostExeNode(PostExeNode iVisited) {
    }

    public void visitRedoNode(RedoNode iVisited) {
        throw new RedoJump();
    }

    public void visitRescueBodyNode(RescueBodyNode iVisited) {
        this.eval(iVisited.getBodyNode());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visitRescueNode(RescueNode iVisited) {
        try {
            block10: {
                Object var7_2;
                while (true) {
                    RescueBodyNode rescueNode;
                    Iterator iter;
                    try {
                        this.eval(iVisited.getBodyNode());
                        if (iVisited.getElseNode() != null) {
                            this.eval(iVisited.getElseNode());
                        }
                        var7_2 = null;
                        break block10;
                    }
                    catch (RaiseException raiseJump) {
                        this.runtime.getGlobalVariables().set("$!", raiseJump.getException());
                        iter = iVisited.getRescueNodes().iterator();
                    }
                    do {
                        if (!iter.hasNext()) {
                            throw raiseJump;
                        }
                        rescueNode = (RescueBodyNode)iter.next();
                    } while (!this.isRescueHandled(raiseJump.getException(), rescueNode.getExceptionNodes()));
                    try {
                        this.eval(rescueNode);
                    }
                    catch (RetryJump retryJump) {
                        this.runtime.getGlobalVariables().set("$!", this.runtime.getNil());
                        var7_2 = null;
                        this.runtime.getGlobalVariables().set("$!", this.runtime.getNil());
                        continue;
                    }
                    break;
                }
                var7_2 = null;
                this.runtime.getGlobalVariables().set("$!", this.runtime.getNil());
                return;
            }
            this.runtime.getGlobalVariables().set("$!", this.runtime.getNil());
            return;
        }
        catch (Throwable throwable) {
            Object var7_3 = null;
            this.runtime.getGlobalVariables().set("$!", this.runtime.getNil());
            throw throwable;
        }
    }

    public void visitRestArgsNode(RestArgsNode iVisited) {
        this.result = this.builtins.toArray(this.eval(iVisited.getArgumentNode()));
    }

    public void visitRetryNode(RetryNode iVisited) {
        throw new RetryJump();
    }

    public void visitReturnNode(ReturnNode iVisited) {
        throw new ReturnJump(this.eval(iVisited.getValueNode()));
    }

    public void visitSClassNode(SClassNode iVisited) {
        IRubyObject receiver = this.eval(iVisited.getReceiverNode());
        RubyClass singletonClass = null;
        if (receiver.isNil()) {
            singletonClass = this.runtime.getClasses().getNilClass();
        } else if (receiver == this.runtime.getTrue()) {
            singletonClass = this.runtime.getClasses().getTrueClass();
        } else if (receiver == this.runtime.getFalse()) {
            singletonClass = this.runtime.getClasses().getFalseClass();
        } else {
            if (this.runtime.getSafeLevel() >= 4 && !receiver.isTaint()) {
                throw new SecurityError(this.runtime, "Insecure: can't extend object.");
            }
            if (receiver.getMetaClass() instanceof MetaClass) {
                RubyModule.clearMethodCache(this.runtime);
            }
            singletonClass = receiver.getSingletonClass();
        }
        if (this.runtime.getWrapper() != null) {
            singletonClass.extendObject(this.runtime.getWrapper());
            singletonClass.includeModule(this.runtime.getWrapper());
        }
        this.evalClassDefinitionBody(iVisited.getBodyNode(), singletonClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitScopeNode(ScopeNode iVisited) {
        this.threadContext.getCurrentFrame().tmpPush();
        this.threadContext.getScopeStack().push(iVisited.getLocalNames());
        try {
            this.eval(iVisited.getBodyNode());
            Object var3_2 = null;
            this.threadContext.getScopeStack().pop();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.threadContext.getScopeStack().pop();
            this.threadContext.getCurrentFrame().tmpPop();
            throw throwable;
        }
        this.threadContext.getCurrentFrame().tmpPop();
    }

    public void visitSelfNode(SelfNode iVisited) {
        this.result = this.self;
    }

    public void visitStrNode(StrNode iVisited) {
        this.result = this.builtins.toString(iVisited.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitSuperNode(SuperNode iVisited) {
        if (this.threadContext.getCurrentFrame().getLastClass() == null) {
            throw new NameError(this.runtime, "Superclass method '" + this.threadContext.getCurrentFrame().getLastFunc() + "' disabled.");
        }
        Block tmpBlock = ArgsUtil.beginCallArgs(this.runtime);
        IRubyObject[] args = null;
        try {
            args = ArgsUtil.setupArgs(this.runtime, this, iVisited.getArgsNode());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ArgsUtil.endCallArgs(this.runtime, tmpBlock);
            throw throwable;
        }
        ArgsUtil.endCallArgs(this.runtime, tmpBlock);
        this.threadContext.callSuper(args);
    }

    public void visitTrueNode(TrueNode iVisited) {
        this.result = this.runtime.getTrue();
    }

    public void visitUndefNode(UndefNode iVisited) {
        if (this.runtime.getRubyClass() == null) {
            throw new TypeError(this.runtime, "No class to undef method '" + iVisited.getName() + "'.");
        }
        this.runtime.getRubyClass().undef(iVisited.getName());
    }

    public void visitUntilNode(UntilNode iVisited) {
        block4: while (!this.eval(iVisited.getConditionNode()).isTrue()) {
            while (true) {
                try {
                    this.eval(iVisited.getBodyNode());
                    continue block4;
                }
                catch (RedoJump rJump) {
                    continue;
                }
                catch (NextJump nJump) {
                    continue block4;
                }
                catch (BreakJump bJump) {
                    return;
                }
                break;
            }
        }
    }

    public void visitVAliasNode(VAliasNode iVisited) {
        this.runtime.getGlobalVariables().alias(iVisited.getNewName(), iVisited.getOldName());
    }

    public void visitVCallNode(VCallNode iVisited) {
        this.result = this.self.getMetaClass().call(this.self, iVisited.getMethodName(), IRubyObject.NULL_ARRAY, CallType.VARIABLE);
    }

    public void visitWhenNode(WhenNode iVisited) {
        this.eval(iVisited.getBodyNode());
    }

    public void visitWhileNode(WhileNode iVisited) {
        block4: while (this.eval(iVisited.getConditionNode()).isTrue()) {
            while (true) {
                try {
                    this.eval(iVisited.getBodyNode());
                    continue block4;
                }
                catch (RedoJump rJump) {
                    continue;
                }
                catch (NextJump nJump) {
                    continue block4;
                }
                catch (BreakJump bJump) {
                    return;
                }
                break;
            }
        }
    }

    public void visitXStrNode(XStrNode iVisited) {
        this.result = this.self.callMethod("`", this.builtins.toString(iVisited.getValue()));
    }

    public void visitYieldNode(YieldNode iVisited) {
        this.eval(iVisited.getArgsNode());
        if (iVisited.getArgsNode() instanceof ExpandArrayNode && ((RubyArray)this.result).getLength() == 1) {
            this.result = ((RubyArray)this.result).first();
        }
        this.result = this.threadContext.yield(this.result, null, null, false);
    }

    public void visitZArrayNode(ZArrayNode iVisited) {
        this.result = this.builtins.newArray();
    }

    public void visitZSuperNode(ZSuperNode iVisited) {
        if (this.threadContext.getCurrentFrame().getLastClass() == null) {
            throw new NameError(this.runtime, "superclass method '" + this.runtime.getCurrentFrame().getLastFunc() + "' disabled");
        }
        IRubyObject[] args = this.threadContext.getCurrentFrame().getArgs();
        this.threadContext.callSuper(args);
    }

    public void visitBignumNode(BignumNode iVisited) {
        this.result = RubyBignum.newBignum(this.runtime, iVisited.getValue());
    }

    public void visitFixnumNode(FixnumNode iVisited) {
        this.result = RubyFixnum.newFixnum(this.runtime, iVisited.getValue());
    }

    public void visitFloatNode(FloatNode iVisited) {
        this.result = RubyFloat.newFloat(this.runtime, iVisited.getValue());
    }

    public void visitRegexpNode(RegexpNode iVisited) {
        this.result = RubyRegexp.newRegexp(this.builtins.toString(iVisited.getValue()), iVisited.getOptions());
    }

    public void visitSymbolNode(SymbolNode iVisited) {
        this.result = this.builtins.toSymbol(iVisited.getName());
    }

    public void visitExpandArrayNode(ExpandArrayNode iVisited) {
        this.eval(iVisited.getExpandNode());
        if (!(this.result instanceof RubyArray)) {
            this.result = this.result.isNil() ? RubyArray.newArray(this.runtime, 0L) : RubyArray.newArray(this.runtime, this.result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalClassDefinitionBody(ScopeNode iVisited, RubyModule type) {
        this.threadContext.getCurrentFrame().tmpPush();
        this.runtime.pushClass(type);
        this.threadContext.getScopeStack().push(iVisited.getLocalNames());
        this.threadContext.pushDynamicVars();
        this.runtime.setNamespace(new Namespace(type, this.runtime.getNamespace()));
        this.threadContext.getCurrentFrame().setNamespace(this.runtime.getNamespace());
        IRubyObject oldSelf = this.self;
        try {
            if (this.isTrace()) {
                this.callTraceFunction("class", type);
            }
            this.self = type;
            this.eval(iVisited.getBodyNode());
        }
        finally {
            this.self = oldSelf;
            this.runtime.setNamespace(this.runtime.getNamespace().getParent());
            this.threadContext.popDynamicVars();
            this.threadContext.getScopeStack().pop();
            this.runtime.popClass();
            this.threadContext.getCurrentFrame().tmpPop();
            if (this.isTrace()) {
                this.callTraceFunction("end", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRescueHandled(RubyException currentException, IListNode exceptionNodes) {
        if (exceptionNodes == null) {
            return currentException.isKindOf(this.runtime.getExceptions().getStandardError());
        }
        Block tmpBlock = ArgsUtil.beginCallArgs(this.runtime);
        IRubyObject[] args = null;
        try {
            args = ArgsUtil.setupArgs(this.runtime, this, exceptionNodes);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ArgsUtil.endCallArgs(this.runtime, tmpBlock);
            throw throwable;
        }
        ArgsUtil.endCallArgs(this.runtime, tmpBlock);
        int i = 0;
        while (i < args.length) {
            if (!args[i].isKindOf(this.runtime.getClasses().getModuleClass())) {
                throw new TypeError(this.runtime, "class or module required for rescue clause");
            }
            if (currentException.isKindOf((RubyModule)args[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

