/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.SecurityError;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ReadonlyAccessor;
import org.jruby.internal.runtime.UndefinedAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.IGlobalVariables;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public class GlobalVariables
implements IGlobalVariables {
    private Ruby runtime;
    private Map globalVariables = new HashMap();

    public GlobalVariables(Ruby runtime) {
        this.runtime = runtime;
    }

    public void define(String name, IAccessor accessor) {
        Asserts.notNull(name);
        Asserts.notNull(accessor);
        Asserts.isTrue(name.startsWith("$"));
        this.globalVariables.put(name, new GlobalVariable(accessor));
    }

    public void defineReadonly(String name, IAccessor accessor) {
        Asserts.notNull(name);
        Asserts.notNull(accessor);
        Asserts.isTrue(name.startsWith("$"));
        this.globalVariables.put(name, new GlobalVariable(new ReadonlyAccessor(name, accessor)));
    }

    public boolean isDefined(String name) {
        Asserts.notNull(name);
        Asserts.isTrue(name.startsWith("$"));
        GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
        return variable != null && !(variable.getAccessor() instanceof UndefinedAccessor);
    }

    public void alias(String name, String oldName) {
        Asserts.notNull(name);
        Asserts.notNull(oldName);
        Asserts.isTrue(name.startsWith("$"));
        Asserts.isTrue(oldName.startsWith("$"));
        if (this.runtime.getSafeLevel() >= 4) {
            throw new SecurityError(this.runtime, "Insecure: can't alias global variable");
        }
        GlobalVariable oldVariable = this.createIfNotDefined(oldName);
        GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
        if (variable != null && oldVariable != variable && variable.isTracing()) {
            throw new RaiseException(this.runtime, "RuntimeError", "can't alias in tracer");
        }
        this.globalVariables.put(name, oldVariable);
    }

    public IRubyObject get(String name) {
        Asserts.notNull(name);
        Asserts.isTrue(name.startsWith("$"));
        GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
        if (variable != null) {
            return variable.getAccessor().getValue();
        }
        this.runtime.getErrorHandler().warning("global variable `" + name + "' not initialized");
        return this.runtime.getNil();
    }

    public IRubyObject set(String name, IRubyObject value) {
        Asserts.notNull(name);
        Asserts.isTrue(name.startsWith("$"));
        if (this.runtime.getSafeLevel() >= 4) {
            throw new SecurityError(this.runtime, "Insecure: can't change global variable value");
        }
        GlobalVariable variable = this.createIfNotDefined(name);
        IRubyObject result = variable.getAccessor().setValue(value);
        return result;
    }

    public Iterator getNames() {
        return this.globalVariables.keySet().iterator();
    }

    private GlobalVariable createIfNotDefined(String name) {
        GlobalVariable variable = (GlobalVariable)this.globalVariables.get(name);
        if (variable == null) {
            variable = GlobalVariable.newUndefined(this.runtime, name);
            this.globalVariables.put(name, variable);
        }
        return variable;
    }
}

