/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.exceptions.NameError;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public class ReadonlyAccessor
implements IAccessor {
    private String name;
    private IAccessor accessor;

    public ReadonlyAccessor(String name, IAccessor accessor) {
        Asserts.notNull(name);
        Asserts.notNull(accessor);
        this.name = name;
        this.accessor = accessor;
    }

    public IRubyObject getValue() {
        return this.accessor.getValue();
    }

    public IRubyObject setValue(IRubyObject newValue) {
        Asserts.notNull(newValue);
        throw new NameError(newValue.getRuntime(), "can't set variable " + this.name);
    }
}

