/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public class UndefinedAccessor
implements IAccessor {
    private final Ruby runtime;
    private final GlobalVariable globalVariable;
    private final String notInitializedWarning;

    public UndefinedAccessor(Ruby runtime, GlobalVariable globalVariable, String name) {
        Asserts.notNull(runtime);
        Asserts.notNull(globalVariable);
        Asserts.notNull(name);
        this.runtime = runtime;
        this.globalVariable = globalVariable;
        this.notInitializedWarning = "global variable `" + name + "' not initialized";
    }

    public IRubyObject getValue() {
        this.runtime.getErrorHandler().warning(this.notInitializedWarning);
        return this.runtime.getNil();
    }

    public IRubyObject setValue(IRubyObject newValue) {
        Asserts.notNull(newValue);
        this.globalVariable.setAccessor(new ValueAccessor(newValue));
        return newValue;
    }
}

