/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.builtin.definitions;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.definitions.ClassDefinition;
import org.jruby.runtime.builtin.definitions.MethodContext;
import org.jruby.runtime.builtin.definitions.SingletonMethodContext;
import org.jruby.util.Asserts;

public class FixnumDefinition
extends ClassDefinition {
    private static final int FIXNUM = 61440;
    private static final int STATIC = 61696;
    public static final int TO_F = 61441;
    public static final int TO_S = 61442;
    public static final int TAINT = 61443;
    public static final int FREEZE = 61444;
    public static final int OP_LSHIFT = 61445;
    public static final int OP_RSHIFT = 61446;
    public static final int OP_PLUS = 61447;
    public static final int OP_MINUS = 61448;
    public static final int OP_MUL = 61449;
    public static final int OP_DIV = 61450;
    public static final int OP_MOD = 61451;
    public static final int OP_POW = 61452;
    public static final int EQUAL = 61453;
    public static final int OP_CMP = 61454;
    public static final int OP_GT = 61455;
    public static final int OP_GE = 61456;
    public static final int OP_LT = 61457;
    public static final int OP_LE = 61458;
    public static final int OP_AND = 61459;
    public static final int OP_OR = 61460;
    public static final int OP_XOR = 61461;
    public static final int SIZE = 61462;
    public static final int AREF = 61463;
    public static final int HASH = 61464;
    public static final int ID2NAME = 61465;
    public static final int INVERT = 61466;
    public static final int ID = 61467;
    public static final int INDUCED_FROM = 61697;

    public FixnumDefinition(Ruby runtime) {
        super(runtime);
    }

    protected RubyClass createType(Ruby runtime) {
        return runtime.defineClass("Fixnum", (RubyClass)runtime.getClasses().getClass("Integer"));
    }

    protected void defineMethods(MethodContext context) {
        context.create("to_f", 61441, 0);
        context.create("to_s", 61442, 0);
        context.create("to_str", 61442, 0);
        context.create("taint", 61443, 0);
        context.create("freeze", 61444, 0);
        context.create("<<", 61445, 1);
        context.create(">>", 61446, 1);
        context.create("+", 61447, 1);
        context.create("-", 61448, 1);
        context.create("*", 61449, 1);
        context.create("/", 61450, 1);
        context.create("%", 61451, 1);
        context.create("**", 61452, 1);
        context.create("==", 61453, 1);
        context.create("eql?", 61453, 1);
        context.create("equal?", 61453, 1);
        context.create("<=>", 61454, 1);
        context.create(">", 61455, 1);
        context.create(">=", 61456, 1);
        context.create("<", 61457, 1);
        context.create("<=", 61458, 1);
        context.create("&", 61459, 1);
        context.create("|", 61460, 1);
        context.create("^", 61461, 1);
        context.create("size", 61462, 0);
        context.create("[]", 61463, 1);
        context.create("hash", 61464, 0);
        context.create("id2name", 61465, 0);
        context.create("~", 61466, 0);
        context.create("id", 61467, 0);
    }

    protected void defineSingletonMethods(SingletonMethodContext context) {
        context.create("induced_from", 61697, 1);
    }

    public IRubyObject callIndexed(int index, IRubyObject receiver, IRubyObject[] args) {
        switch (index) {
            case 61697: {
                return RubyFixnum.induced_from(receiver, args[0]);
            }
        }
        Asserts.notReached();
        return null;
    }
}

