/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.builtin.definitions;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.definitions.ClassDefinition;
import org.jruby.runtime.builtin.definitions.MethodContext;
import org.jruby.runtime.builtin.definitions.SingletonMethodContext;
import org.jruby.util.Asserts;

public class HashDefinition
extends ClassDefinition {
    private static final int HASH = 61440;
    private static final int STATIC = 61696;
    public static final int INITIALIZE = 61441;
    public static final int RBCLONE = 61442;
    public static final int REHASH = 61443;
    public static final int TO_HASH = 61444;
    public static final int TO_A = 61445;
    public static final int TO_S = 61446;
    public static final int INSPECT = 61447;
    public static final int EQUAL = 61448;
    public static final int AREF = 61449;
    public static final int FETCH = 61450;
    public static final int ASET = 61451;
    public static final int GETDEFAULTVALUE = 61452;
    public static final int SETDEFAULTVALUE = 61453;
    public static final int INDEX = 61454;
    public static final int INDICES = 61455;
    public static final int SIZE = 61456;
    public static final int EMPTY_P = 61457;
    public static final int EACH = 61458;
    public static final int EACH_VALUE = 61459;
    public static final int EACH_KEY = 61460;
    public static final int SORT = 61461;
    public static final int KEYS = 61462;
    public static final int VALUES = 61463;
    public static final int SHIFT = 61464;
    public static final int DELETE = 61465;
    public static final int DELETE_IF = 61466;
    public static final int REJECT = 61467;
    public static final int REJECT_BANG = 61468;
    public static final int CLEAR = 61469;
    public static final int INVERT = 61470;
    public static final int UPDATE = 61471;
    public static final int REPLACE = 61472;
    public static final int HAS_KEY = 61473;
    public static final int HAS_VALUE = 61474;
    public static final int NEWINSTANCE = 61697;
    public static final int CREATE = 61698;

    public HashDefinition(Ruby runtime) {
        super(runtime);
    }

    protected RubyClass createType(Ruby runtime) {
        RubyClass result = runtime.defineClass("Hash", (RubyClass)runtime.getClasses().getClass("Object"));
        result.includeModule(runtime.getClasses().getClass("Enumerable"));
        return result;
    }

    protected void defineMethods(MethodContext context) {
        context.createOptional("initialize", 61441, 0);
        context.create("clone", 61442, 0);
        context.create("rehash", 61443, 0);
        context.create("to_hash", 61444, 0);
        context.create("to_a", 61445, 0);
        context.create("to_s", 61446, 0);
        context.create("inspect", 61447, 0);
        context.create("==", 61448, 1);
        context.create("[]", 61449, 1);
        context.createOptional("fetch", 61450, 0);
        context.create("[]=", 61451, 2);
        context.create("store", 61451, 2);
        context.create("default", 61452, 0);
        context.create("default=", 61453, 1);
        context.create("index", 61454, 1);
        context.createOptional("indices", 61455, 0);
        context.createOptional("indexes", 61455, 0);
        context.create("size", 61456, 0);
        context.create("length", 61456, 0);
        context.create("empty?", 61457, 0);
        context.create("each", 61458, 0);
        context.create("each_pair", 61458, 0);
        context.create("each_value", 61459, 0);
        context.create("each_key", 61460, 0);
        context.create("sort", 61461, 0);
        context.create("keys", 61462, 0);
        context.create("values", 61463, 0);
        context.create("shift", 61464, 0);
        context.create("delete", 61465, 1);
        context.create("delete_if", 61466, 0);
        context.create("reject", 61467, 0);
        context.create("reject!", 61468, 0);
        context.create("clear", 61469, 0);
        context.create("invert", 61470, 0);
        context.create("update", 61471, 1);
        context.create("replace", 61472, 1);
        context.create("has_key?", 61473, 1);
        context.create("include?", 61473, 1);
        context.create("member?", 61473, 1);
        context.create("key?", 61473, 1);
        context.create("has_value?", 61474, 1);
        context.create("value?", 61474, 1);
    }

    protected void defineSingletonMethods(SingletonMethodContext context) {
        context.createOptional("new", 61697, 0);
        context.createOptional("[]", 61698, 0);
    }

    public IRubyObject callIndexed(int index, IRubyObject receiver, IRubyObject[] args) {
        switch (index) {
            case 61697: {
                return RubyHash.newInstance(receiver, args);
            }
            case 61698: {
                return RubyHash.create(receiver, args);
            }
        }
        Asserts.notReached();
        return null;
    }
}

