/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.Visibility;

public class CacheEntry {
    private String name;
    private String originalName;
    private RubyModule recvClass;
    private RubyModule origin;
    private ICallable method;
    private Visibility visibility;

    private CacheEntry(String name, String originalName, RubyModule recvClass, RubyModule origin, ICallable method, Visibility visibility) {
        this.name = name;
        this.originalName = originalName;
        this.recvClass = recvClass;
        this.origin = origin;
        this.method = method;
        this.visibility = visibility;
    }

    public CacheEntry(String name, RubyModule recvClass) {
        this(name, name, recvClass, null, null, null);
    }

    public static CacheEntry createUndefined(String name, RubyModule recvClass) {
        return new CacheEntry(name, name, recvClass, recvClass, UndefinedMethod.getInstance(), Visibility.PUBLIC);
    }

    public RubyModule getRecvClass() {
        return this.recvClass;
    }

    public void setRecvClass(RubyModule recvClass) {
        this.recvClass = recvClass;
    }

    public ICallable getMethod() {
        return this.method;
    }

    public void setMethod(ICallable method) {
        this.method = method;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public RubyModule getOrigin() {
        return this.origin;
    }

    public void setOrigin(RubyModule origin) {
        this.origin = origin;
    }

    public boolean isDefined() {
        return !this.getMethod().isUndefined();
    }
}

