/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.ablaf.common.ISourcePosition;
import org.jruby.Ruby;
import org.jruby.internal.runtime.methods.AbstractMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Callback;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CallbackMethod
extends AbstractMethod {
    private Callback callback;

    public CallbackMethod(Callback callback, Visibility visibility) {
        super(visibility);
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(Ruby ruby, IRubyObject receiver, String name, IRubyObject[] args, boolean noSuper) {
        if (ruby.getTraceFunction() != null) {
            ISourcePosition position = ruby.getFrameStack().getPrevious().getPosition();
            if (position == null) {
                position = ruby.getPosition();
            }
            ruby.callTraceFunction("c-call", position, receiver, name, this.getImplementationClass());
            try {
                IRubyObject iRubyObject = this.callback.execute(receiver, args);
                Object var9_8 = null;
                ruby.callTraceFunction("c-return", position, receiver, name, this.getImplementationClass());
                return iRubyObject;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ruby.callTraceFunction("c-return", position, receiver, name, this.getImplementationClass());
                throw throwable;
            }
        }
        return this.callback.execute(receiver, args);
    }

    public Callback getCallback() {
        return this.callback;
    }

    public Arity getArity() {
        return this.getCallback().getArity();
    }
}

