/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.ArgumentError;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class Java {
    static /* synthetic */ Class class$org$jruby$javasupport$Java;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;
    static /* synthetic */ Class class$java$lang$Object;

    public static RubyModule createJavaModule(Ruby runtime) {
        RubyModule javaModule = runtime.defineModule("Java");
        javaModule.defineModuleFunction("define_exception_handler", CallbackFactory.getOptSingletonMethod(class$org$jruby$javasupport$Java == null ? (class$org$jruby$javasupport$Java = Java.class$("org.jruby.javasupport.Java")) : class$org$jruby$javasupport$Java, "define_exception_handler"));
        javaModule.defineModuleFunction("primitive_to_java", CallbackFactory.getSingletonMethod(class$org$jruby$javasupport$Java == null ? (class$org$jruby$javasupport$Java = Java.class$("org.jruby.javasupport.Java")) : class$org$jruby$javasupport$Java, "primitive_to_java", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = Java.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        javaModule.defineModuleFunction("java_to_primitive", CallbackFactory.getSingletonMethod(class$org$jruby$javasupport$Java == null ? (class$org$jruby$javasupport$Java = Java.class$("org.jruby.javasupport.Java")) : class$org$jruby$javasupport$Java, "java_to_primitive", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = Java.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        javaModule.defineModuleFunction("new_proxy_instance", CallbackFactory.getOptSingletonMethod(class$org$jruby$javasupport$Java == null ? (class$org$jruby$javasupport$Java = Java.class$("org.jruby.javasupport.Java")) : class$org$jruby$javasupport$Java, "new_proxy_instance"));
        JavaClass.createJavaClassClass(runtime, javaModule);
        JavaMethod.createJavaMethodClass(runtime, javaModule);
        JavaConstructor.createJavaConstructorClass(runtime, javaModule);
        JavaField.createJavaFieldClass(runtime, javaModule);
        return javaModule;
    }

    public static IRubyObject define_exception_handler(IRubyObject recv, IRubyObject[] args) {
        String name = args[0].toString();
        RubyProc handler = null;
        handler = args.length > 1 ? (RubyProc)args[1] : RubyProc.newProc(recv.getRuntime());
        recv.getRuntime().getJavaSupport().defineExceptionHandler(name, handler);
        return recv;
    }

    public static IRubyObject primitive_to_java(IRubyObject recv, IRubyObject object) {
        Ruby runtime = recv.getRuntime();
        Object javaObject = JavaUtil.convertRubyToJava(object);
        return JavaObject.wrap(runtime, javaObject);
    }

    public static IRubyObject java_to_primitive(IRubyObject recv, IRubyObject object) {
        if (object instanceof JavaObject) {
            return JavaUtil.convertJavaToRuby(recv.getRuntime(), ((JavaObject)object).getValue());
        }
        return object;
    }

    public static IRubyObject new_proxy_instance(final IRubyObject recv, IRubyObject[] args) {
        if (args.length < 1) {
            throw new ArgumentError(recv.getRuntime(), "wrong # of arguments(" + args.length + " for 1)");
        }
        final RubyProc proc = args[args.length - 1] instanceof RubyProc ? (RubyProc)args[args.length - 1] : RubyProc.newProc(recv.getRuntime());
        int size = args[args.length - 1] instanceof RubyProc ? args.length - 1 : args.length;
        Class[] interfaces = new Class[size];
        int i = 0;
        while (i < size) {
            if (!(args[i] instanceof JavaClass) || !((JavaClass)args[i]).interface_p().isTrue()) {
                throw new ArgumentError(recv.getRuntime(), "Java interface expected.");
            }
            interfaces[i] = ((JavaClass)args[i]).getValue();
            ++i;
        }
        return JavaObject.wrap(recv.getRuntime(), Proxy.newProxyInstance(recv.getRuntime().getJavaSupport().getJavaClassLoader(), interfaces, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("toString") && method.getParameterTypes().length == 0) {
                    return proxy.getClass().getName();
                }
                if (method.getName().equals("hashCode") && method.getParameterTypes().length == 0) {
                    return new Integer(proxy.getClass().hashCode());
                }
                if (method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(class$java$lang$Object == null ? (class$java$lang$Object = Java.class$("java.lang.Object")) : class$java$lang$Object)) {
                    return proxy == args[1];
                }
                int length = args == null ? 0 : args.length;
                IRubyObject[] rubyArgs = new IRubyObject[length + 2];
                rubyArgs[0] = JavaObject.wrap(recv.getRuntime(), proxy);
                rubyArgs[1] = new JavaMethod(recv.getRuntime(), method);
                int i = 0;
                while (i < length) {
                    rubyArgs[i + 2] = JavaObject.wrap(recv.getRuntime(), args[i]);
                    ++i;
                }
                return JavaUtil.convertArgument(proc.call(rubyArgs), method.getReturnType());
            }
        }));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

