/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;

public abstract class JavaCallable
extends RubyObject {
    public JavaCallable(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public final RubyFixnum arity() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.getArity());
    }

    public final RubyArray argument_types() {
        Class[] parameterTypes = this.parameterTypes();
        RubyArray result = RubyArray.newArray(this.getRuntime(), parameterTypes.length);
        int i = 0;
        while (i < parameterTypes.length) {
            result.append(RubyString.newString(this.getRuntime(), parameterTypes[i].getName()));
            ++i;
        }
        return result;
    }

    public final RubyString inspect() {
        StringBuffer result = new StringBuffer();
        result.append(this.nameOnInspection());
        Class[] parameterTypes = this.parameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            result.append(parameterTypes[i].getName());
            if (i < parameterTypes.length - 1) {
                result.append(',');
            }
            ++i;
        }
        result.append(")>");
        return RubyString.newString(this.getRuntime(), result.toString());
    }

    protected abstract int getArity();

    protected abstract Class[] parameterTypes();

    protected abstract String nameOnInspection();
}

