/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.TypeError;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.IndexedCallback;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public class JavaConstructor
extends JavaCallable
implements IndexCallable {
    private final Constructor constructor;
    private static final int ARITY = 1;
    private static final int NEW_INSTANCE = 2;
    private static final int INSPECT = 3;
    private static final int ARGUMENT_TYPES = 4;

    public static RubyClass createJavaConstructorClass(Ruby runtime, RubyModule javaModule) {
        RubyClass javaConstructorClass = javaModule.defineClassUnder("JavaConstructor", runtime.getClasses().getObjectClass());
        javaConstructorClass.defineMethod("arity", IndexedCallback.create(1, 0));
        javaConstructorClass.defineMethod("new_instance", IndexedCallback.createOptional(2));
        javaConstructorClass.defineMethod("inspect", IndexedCallback.create(3, 0));
        javaConstructorClass.defineMethod("argument_types", IndexedCallback.create(4, 0));
        return javaConstructorClass;
    }

    public JavaConstructor(Ruby runtime, Constructor constructor) {
        super(runtime, (RubyClass)runtime.getClasses().getClassFromPath("Java::JavaConstructor"));
        this.constructor = constructor;
    }

    public int getArity() {
        return this.constructor.getParameterTypes().length;
    }

    public IRubyObject new_instance(IRubyObject[] args) {
        if (args.length != this.getArity()) {
            throw new ArgumentError(this.getRuntime(), args.length, this.getArity());
        }
        Object[] constructorArguments = new Object[args.length];
        Class<?>[] types = this.constructor.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            constructorArguments[i] = JavaUtil.convertArgument(args[i], types[i]);
            ++i;
        }
        try {
            Object result = this.constructor.newInstance(constructorArguments);
            return JavaObject.wrap(this.getRuntime(), result);
        }
        catch (IllegalArgumentException iae) {
            throw new TypeError(this.getRuntime(), "expected " + this.argument_types().inspect() + ", got [" + constructorArguments[0].getClass().getName() + ", ...]");
        }
        catch (IllegalAccessException iae) {
            throw new TypeError(this.getRuntime(), "illegal access");
        }
        catch (InvocationTargetException ite) {
            this.getRuntime().getJavaSupport().handleNativeException((Exception)ite.getTargetException());
            Asserts.notReached();
            return null;
        }
        catch (InstantiationException ie) {
            throw new TypeError(this.getRuntime(), "can't make instance of " + this.constructor.getDeclaringClass().getName());
        }
    }

    protected String nameOnInspection() {
        return this.getType().toString();
    }

    protected Class[] parameterTypes() {
        return this.constructor.getParameterTypes();
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 1: {
                return this.arity();
            }
            case 2: {
                return this.new_instance(args);
            }
            case 3: {
                return this.inspect();
            }
            case 4: {
                return this.argument_types();
            }
        }
        return super.callIndexed(index, args);
    }
}

