/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.TypeError;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.IndexedCallback;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaMethod
extends JavaCallable
implements IndexCallable {
    private final Method method;
    private static final int NAME = 1;
    private static final int ARITY = 2;
    private static final int PUBLIC_P = 3;
    private static final int FINAL_P = 4;
    private static final int INVOKE = 5;
    private static final int INVOKE_STATIC = 6;
    private static final int ARGUMENT_TYPES = 7;
    private static final int INSPECT = 8;
    private static final int STATIC_P = 9;
    private static final int RETURN_TYPE = 10;

    public static RubyClass createJavaMethodClass(Ruby runtime, RubyModule javaModule) {
        RubyClass javaMethodClass = javaModule.defineClassUnder("JavaMethod", runtime.getClasses().getObjectClass());
        javaMethodClass.defineMethod("name", IndexedCallback.create(1, 0));
        javaMethodClass.defineMethod("arity", IndexedCallback.create(2, 0));
        javaMethodClass.defineMethod("public?", IndexedCallback.create(3, 0));
        javaMethodClass.defineMethod("final?", IndexedCallback.create(4, 0));
        javaMethodClass.defineMethod("invoke", IndexedCallback.createOptional(5, 1));
        javaMethodClass.defineMethod("invoke_static", IndexedCallback.createOptional(6));
        javaMethodClass.defineMethod("argument_types", IndexedCallback.create(7, 0));
        javaMethodClass.defineMethod("inspect", IndexedCallback.create(8, 0));
        javaMethodClass.defineMethod("static?", IndexedCallback.create(9, 0));
        javaMethodClass.defineMethod("return_type", IndexedCallback.create(10, 0));
        return javaMethodClass;
    }

    public JavaMethod(Ruby runtime, Method method) {
        super(runtime, (RubyClass)runtime.getClasses().getClassFromPath("Java::JavaMethod"));
        this.method = method;
    }

    public static JavaMethod create(Ruby runtime, Method method) {
        return new JavaMethod(runtime, method);
    }

    public static JavaMethod create(Ruby runtime, Class javaClass, String methodName, Class[] argumentTypes) {
        try {
            Method method = javaClass.getMethod(methodName, argumentTypes);
            return JavaMethod.create(runtime, method);
        }
        catch (NoSuchMethodException e) {
            throw new NameError(runtime, "undefined method '" + methodName + "' for class '" + javaClass.getName() + "'");
        }
    }

    public RubyString name() {
        return RubyString.newString(this.getRuntime(), this.method.getName());
    }

    protected int getArity() {
        return this.method.getParameterTypes().length;
    }

    public RubyBoolean public_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Modifier.isPublic(this.method.getModifiers()));
    }

    public RubyBoolean final_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Modifier.isFinal(this.method.getModifiers()));
    }

    public IRubyObject invoke(IRubyObject[] args) {
        if (args.length != 1 + this.getArity()) {
            throw new ArgumentError(this.getRuntime(), args.length, 1 + this.getArity());
        }
        IRubyObject invokee = args[0];
        if (!(invokee instanceof JavaObject)) {
            throw new TypeError(this.getRuntime(), "invokee not a java object");
        }
        Object javaInvokee = ((JavaObject)invokee).getValue();
        Object[] arguments = new Object[args.length - 1];
        System.arraycopy(args, 1, arguments, 0, arguments.length);
        this.convertArguments(arguments);
        if (!this.method.getDeclaringClass().isInstance(javaInvokee)) {
            throw new TypeError(this.getRuntime(), "invokee not instance of method's class (got" + javaInvokee.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
        }
        return this.invokeWithExceptionHandling(javaInvokee, arguments);
    }

    public IRubyObject invoke_static(IRubyObject[] args) {
        if (args.length != this.getArity()) {
            throw new ArgumentError(this.getRuntime(), args.length, this.getArity());
        }
        Object[] arguments = new Object[args.length];
        System.arraycopy(args, 0, arguments, 0, arguments.length);
        this.convertArguments(arguments);
        return this.invokeWithExceptionHandling(null, arguments);
    }

    public IRubyObject return_type() {
        String result = this.method.getReturnType().getName();
        if (result.equals("void")) {
            return this.getRuntime().getNil();
        }
        return RubyString.newString(this.getRuntime(), result);
    }

    private IRubyObject invokeWithExceptionHandling(Object javaInvokee, Object[] arguments) {
        try {
            Object result = this.method.invoke(javaInvokee, arguments);
            return JavaObject.wrap(this.runtime, result);
        }
        catch (IllegalArgumentException iae) {
            throw new TypeError(this.getRuntime(), "expected " + this.argument_types().inspect());
        }
        catch (IllegalAccessException iae) {
            throw new TypeError(this.getRuntime(), "illegal access on '" + this.method.getName() + "': " + iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            this.getRuntime().getJavaSupport().handleNativeException((Exception)ite.getTargetException());
            return this.runtime.getNil();
        }
    }

    private void convertArguments(Object[] arguments) {
        Class[] parameterTypes = this.parameterTypes();
        int i = 0;
        while (i < arguments.length) {
            arguments[i] = JavaUtil.convertArgument(arguments[i], parameterTypes[i]);
            ++i;
        }
    }

    protected Class[] parameterTypes() {
        return this.method.getParameterTypes();
    }

    protected String nameOnInspection() {
        return "#<" + this.getType().toString() + "/" + this.method.getName() + "(";
    }

    public RubyBoolean static_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.isStatic());
    }

    private boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 1: {
                return this.name();
            }
            case 2: {
                return this.arity();
            }
            case 3: {
                return this.public_p();
            }
            case 4: {
                return this.final_p();
            }
            case 5: {
                return this.invoke(args);
            }
            case 6: {
                return this.invoke_static(args);
            }
            case 7: {
                return this.argument_types();
            }
            case 8: {
                return this.inspect();
            }
            case 9: {
                return this.static_p();
            }
            case 10: {
                return this.return_type();
            }
        }
        return super.callIndexed(index, args);
    }
}

