/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.RubyClass;
import org.jruby.javasupport.RubyToJavaClassMap;

public class ReflectionClassMap
implements RubyToJavaClassMap {
    private String javaPackage = null;

    public ReflectionClassMap(String pkgName) {
        this.javaPackage = pkgName;
    }

    public ReflectionClassMap(Package pkg) {
        this.javaPackage = pkg.getName();
    }

    public String getRubyClassNameForJavaClass(Class javaClass) {
        String name = javaClass.getName();
        if (name.lastIndexOf(".") >= 0) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        return name;
    }

    public Class getJavaClassForRubyClass(RubyClass rubyClass) {
        while (rubyClass != null) {
            try {
                String rubyClassName = rubyClass.getClassname();
                String javaClassName = this.javaPackage + "." + rubyClassName;
                return Class.forName(javaClassName);
            }
            catch (ClassNotFoundException ex) {
                if (rubyClass.superclass().isNil() || (rubyClass = (RubyClass)rubyClass.superclass()) != null && rubyClass.getClassname() == null) break;
            }
        }
        return null;
    }
}

