/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.RubyProxy;
import org.jruby.javasupport.RubyProxyFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyConversion {
    RubyProxyFactory factory = null;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Boolean;

    public RubyConversion(RubyProxyFactory factory) {
        this.factory = factory;
    }

    public Ruby getRuby() {
        return this.factory.getRuby();
    }

    public IRubyObject[] convertJavaToRuby(Object[] obj) {
        if (obj == null || obj.length == 0) {
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] ret = new IRubyObject[obj.length];
        int i = 0;
        while (i < obj.length) {
            ret[i] = this.convertJavaToRuby(obj[i]);
            ++i;
        }
        return ret;
    }

    public IRubyObject convertJavaToRuby(Object obj) {
        if (obj == null) {
            return this.getRuby().getNil();
        }
        if (obj instanceof Set) {
            obj = new ArrayList((Set)((Object)obj));
        }
        Class type = RubyConversion.getCanonicalJavaClass(obj.getClass());
        return JavaUtil.convertJavaToRuby(this.getRuby(), obj, type);
    }

    public Object[] convertRubyToJava(IRubyObject[] obj) {
        Object[] ret = new Object[obj.length];
        int i = 0;
        while (i < obj.length) {
            ret[i] = this.convertRubyToJava(obj[i]);
            ++i;
        }
        return ret;
    }

    public Object convertRubyToJava(IRubyObject obj) {
        return this.convertRubyToJava(obj, null);
    }

    public Object convertRubyToJava(IRubyObject obj, Class type) {
        if ((type = RubyConversion.getCanonicalJavaClass(type)) != null) {
            type.getName();
        }
        if (type == Void.TYPE || obj == null || obj.isNil()) {
            return null;
        }
        if (obj instanceof RubyArray) {
            try {
                return this.convertRubyArrayToJava((RubyArray)obj, type);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            RubyProxy proxy = this.factory.getProxyForObject(obj, type);
            if (proxy != null) {
                return proxy;
            }
        }
        catch (Exception ex) {}
        return JavaUtil.convertRubyToJava(obj, type);
    }

    public Object convertRubyArrayToJava(RubyArray array, Class type) throws InstantiationException, IllegalAccessException {
        if (type.isArray()) {
            return JavaUtil.convertRubyToJava(array, type);
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = RubyConversion.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(type)) {
            Collection ret = (Collection)type.newInstance();
            Iterator it = array.getList().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                ret.add(this.convertRubyToJava((IRubyObject)obj));
            }
            return ret;
        }
        throw new UnsupportedOperationException(type.getName() + " not supported");
    }

    private static Class getCanonicalJavaClass(Class type) {
        if (type == (class$java$lang$Double == null ? (class$java$lang$Double = RubyConversion.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.TYPE;
        }
        if (type == (class$java$lang$Float == null ? (class$java$lang$Float = RubyConversion.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.TYPE;
        }
        if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = RubyConversion.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.TYPE;
        }
        if (type == (class$java$lang$Long == null ? (class$java$lang$Long = RubyConversion.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.TYPE;
        }
        if (type == (class$java$lang$Short == null ? (class$java$lang$Short = RubyConversion.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.TYPE;
        }
        if (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = RubyConversion.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.TYPE;
        }
        if (type == (class$java$lang$Character == null ? (class$java$lang$Character = RubyConversion.class$("java.lang.Character")) : class$java$lang$Character)) {
            return Character.TYPE;
        }
        if (type == (class$java$lang$Void == null ? (class$java$lang$Void = RubyConversion.class$("java.lang.Void")) : class$java$lang$Void)) {
            return Void.TYPE;
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = RubyConversion.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.TYPE;
        }
        return type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

