/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.javasupport.RubyProxyFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyInvocationHandler
implements InvocationHandler {
    private RubyProxyFactory factory = null;
    private IRubyObject rubyObject = null;

    RubyInvocationHandler(RubyProxyFactory factory, IRubyObject obj) {
        this.factory = factory;
        this.rubyObject = obj;
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
        IRubyObject out;
        String methodName = method.getName();
        IRubyObject[] rubyArgs = this.factory.convertJavaToRuby(args);
        if (methodName.equals("getRubyObject")) {
            return this.getRubyObject();
        }
        if (methodName.equals("getRubyProxyFactory")) {
            return this.getRubyProxyFactory();
        }
        if (this.respondsTo(this.rubyObject, methodName)) {
            out = this.rubyObject.callMethod(methodName, rubyArgs);
        } else if (methodName.equals("toString")) {
            out = this.rubyObject.callMethod("to_s");
        } else if (methodName.equals("equals")) {
            out = this.rubyObject.callMethod("equal", rubyArgs);
        } else if (methodName.indexOf("get") == 0) {
            String fieldName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            out = this.rubyObject.callMethod(fieldName, rubyArgs);
        } else if (methodName.indexOf("set") == 0) {
            String fieldName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4) + "=";
            out = this.rubyObject.callMethod(fieldName, rubyArgs);
        } else {
            throw new RuntimeException("method " + methodName + " not found.");
        }
        return this.factory.convertRubyToJava(out, method.getReturnType());
    }

    protected Ruby getRuby() {
        return this.factory.getRuby();
    }

    protected RubyProxyFactory getRubyProxyFactory() {
        return this.factory;
    }

    protected IRubyObject getRubyObject() {
        return this.rubyObject;
    }

    protected boolean respondsTo(IRubyObject obj, String methodName) {
        return obj.respondsTo(methodName);
    }
}

