/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import org.ablaf.common.ISourcePosition;
import org.ablaf.internal.lexer.DefaultLexerPosition;
import org.ablaf.internal.lexer.DefaultLexerSupport;
import org.ablaf.lexer.ILexerSource;
import org.jruby.lexer.yacc.IRubyLexerSupport;
import org.jruby.lexer.yacc.LexerException;

public class RubyLexerSupport
extends DefaultLexerSupport
implements IRubyLexerSupport {
    private String buffer = null;
    private int bufferPos = -1;
    private ISourcePosition startPosition = null;

    public RubyLexerSupport(ILexerSource source) {
        super(source);
    }

    public void setBuffer(String buffer, ISourcePosition startPosition) {
        this.buffer = buffer;
        this.bufferPos = 0;
        this.startPosition = startPosition;
    }

    public ISourcePosition getPosition() {
        if (this.bufferPos <= 0) {
            return DefaultLexerPosition.getInstance(this.source.getSourceName(), this.source.getLine() + 1);
        }
        return DefaultLexerPosition.getInstance(this.startPosition.getFile(), this.startPosition.getLine());
    }

    public int getColumn() {
        if (this.bufferPos <= 0) {
            int col = this.source.getOffset();
            if (this.source.getLine() > 0) {
                col -= this.lineOffset[this.source.getLine() - 1];
            }
            return col;
        }
        return this.startPosition.getColumn() + this.bufferPos;
    }

    public char read() {
        if (this.bufferPos == -1) {
            return super.read();
        }
        if (this.bufferPos >= this.buffer.length()) {
            this.bufferPos = -1;
            return super.read();
        }
        return this.buffer.charAt(this.bufferPos++);
    }

    public void unread() {
        if (this.bufferPos == -1) {
            super.unread();
        } else if (this.bufferPos > 0) {
            this.buffer.charAt(--this.bufferPos);
        }
    }

    public char readEscape() throws LexerException {
        char c = this.read();
        switch (c) {
            case '\\': {
                return '\\';
            }
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'v': {
                return '\u0013';
            }
            case 'a': {
                return '\u0007';
            }
            case 'e': {
                return '3';
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                this.unread();
                return (char)Integer.parseInt(this.readOct(3), 8);
            }
            case 'x': {
                return (char)Integer.parseInt(this.readHex(2), 16);
            }
            case 'b': {
                return '\b';
            }
            case 's': {
                return ' ';
            }
            case 'M': {
                c = this.read();
                if (c != '-') {
                    this.unread();
                    throw new LexerException();
                }
                c = this.read();
                if (c == '\\') {
                    return (char)(this.readEscape() | 0x80);
                }
                if (c == '\u0000') {
                    throw new LexerException();
                }
                return (char)(c & 0xFF | 0x80);
            }
            case 'C': {
                c = this.read();
                if (c != '-') {
                    this.unread();
                    throw new LexerException();
                }
            }
            case 'c': {
                c = this.read();
                if (c == '\\') {
                    c = this.readEscape();
                } else {
                    if (c == '?') {
                        return '\u0177';
                    }
                    if (c == '\u0000') {
                        throw new LexerException();
                    }
                }
                return (char)(c & 0x9F);
            }
            case '\u0000': {
                throw new LexerException();
            }
        }
        return c;
    }
}

