/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.main;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.ablaf.ast.IAstEncoder;
import org.ablaf.internal.ast.XmlAstMarshal;
import org.ablaf.internal.common.NullErrorHandler;
import org.ablaf.lexer.ILexerSource;
import org.ablaf.lexer.LexerFactory;
import org.ablaf.parser.IParser;
import org.jruby.ast.util.AstPersistenceDelegates;
import org.jruby.ast.util.RubyAstMarshal;
import org.jruby.parser.IRubyParserResult;
import org.jruby.parser.RubyParserConfiguration;
import org.jruby.parser.RubyParserPool;

public class ASTSerializer {
    public static void serialize(File input, File outputFile) throws IOException {
        OutputStream output = new FileOutputStream(outputFile);
        output = new BufferedOutputStream(output);
        IAstEncoder encoder = RubyAstMarshal.getInstance().openEncoder(output);
        ASTSerializer.serialize(input, encoder);
        encoder.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(File input, IAstEncoder encoder) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(input));
        RubyParserConfiguration config = new RubyParserConfiguration();
        config.setBlockVariables(new ArrayList());
        config.setLocalVariables(new ArrayList());
        IParser parser = null;
        IRubyParserResult result = null;
        try {
            parser = RubyParserPool.getInstance().borrowParser();
            parser.setErrorHandler(new NullErrorHandler());
            parser.init(config);
            ILexerSource lexerSource = LexerFactory.getInstance().getSource(input.toString(), reader);
            result = (IRubyParserResult)parser.parse(lexerSource);
            Object var8_7 = null;
            RubyParserPool.getInstance().returnParser(parser);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            RubyParserPool.getInstance().returnParser(parser);
            throw throwable;
        }
        ((Reader)reader).close();
        encoder.writeNode(result.getAST());
    }

    public static void main(String[] args) throws IOException {
        XmlAstMarshal marshal = new XmlAstMarshal(AstPersistenceDelegates.get());
        IAstEncoder encoder = marshal.openEncoder(new BufferedOutputStream(System.out));
        ASTSerializer.serialize(new File(args[0]), encoder);
        encoder.close();
    }
}

