/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.ablaf.ast.INode;
import org.ablaf.lexer.ILexerSource;
import org.ablaf.lexer.LexerFactory;
import org.ablaf.parser.IParser;
import org.ablaf.parser.IParserPool;
import org.jruby.Ruby;
import org.jruby.parser.IRubyParserResult;
import org.jruby.parser.RubyParserConfiguration;
import org.jruby.parser.RubyParserPool;

public class Parser {
    private final Ruby runtime;
    private final IParserPool pool;

    public Parser(Ruby ruby) {
        this.runtime = ruby;
        this.pool = RubyParserPool.getInstance();
    }

    public INode parse(String file, String content) {
        return this.parse(file, new StringReader(content));
    }

    public INode parse(String file, Reader content) {
        return this.parse(file, content, new RubyParserConfiguration());
    }

    public INode parse(String file, String content, List blockVariableNames) {
        RubyParserConfiguration config = new RubyParserConfiguration();
        config.setBlockVariables(blockVariableNames);
        return this.parse(file, new StringReader(content), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private INode parse(String file, Reader content, RubyParserConfiguration config) {
        config.setLocalVariables(this.runtime.getScope().getLocalNames());
        IParser parser = null;
        IRubyParserResult result = null;
        try {
            parser = this.pool.borrowParser();
            parser.setErrorHandler(this.runtime.getErrorHandler());
            parser.init(config);
            ILexerSource lexerSource = LexerFactory.getInstance().getSource(file, content);
            result = (IRubyParserResult)parser.parse(lexerSource);
            Object var8_7 = null;
            this.pool.returnParser(parser);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.pool.returnParser(parser);
            throw throwable;
        }
        if (this.hasNewLocalVariables(result)) {
            this.expandLocalVariables(result.getLocalVariables());
        }
        return result.getAST();
    }

    private void expandLocalVariables(List localVariables) {
        int oldSize = 0;
        if (this.runtime.getScope().getLocalNames() != null) {
            oldSize = this.runtime.getScope().getLocalNames().size();
        }
        List newNames = localVariables.subList(oldSize, localVariables.size());
        this.runtime.getScope().addLocalVariables(newNames);
    }

    private boolean hasNewLocalVariables(IRubyParserResult result) {
        int newSize = 0;
        if (result.getLocalVariables() != null) {
            newSize = result.getLocalVariables().size();
        }
        int oldSize = 0;
        if (this.runtime.getScope().hasLocalVariables()) {
            oldSize = this.runtime.getScope().getLocalNames().size();
        }
        return newSize > oldSize;
    }
}

