/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.util.IdUtil;

public class LastCallStatus {
    private static final Object NORMAL = new Object();
    private static final Object PRIVATE = new Object();
    private static final Object PROTECTED = new Object();
    private static final Object VARIABLE = new Object();
    private final Ruby runtime;
    private Object status = NORMAL;

    public LastCallStatus(Ruby runtime) {
        this.runtime = runtime;
    }

    public void setNormal() {
        this.status = NORMAL;
    }

    public void setPrivate() {
        this.status = PRIVATE;
    }

    public void setProtected() {
        this.status = PROTECTED;
    }

    public void setVariable() {
        this.status = VARIABLE;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public String errorMessageFormat(String name) {
        String format = "Undefined method '%s' for %s%s%s";
        if (this.status == PRIVATE) {
            format = "private method '%s' called for %s%s%s";
        } else if (this.status == PROTECTED) {
            format = "protected method '%s' called for %s%s%s";
        } else if (this.status == VARIABLE && IdUtil.isLocal(name)) {
            format = "Undefined local variable or method '%s' for %s%s%s";
        }
        return format;
    }
}

