/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.runtime.builtin.IRubyObject;

public class Namespace {
    private final Namespace parent;
    private final RubyModule namespaceModule;

    public Namespace(RubyModule namespaceModule) {
        this(namespaceModule, null);
    }

    public Namespace(RubyModule namespaceModule, Namespace parent) {
        this.namespaceModule = namespaceModule;
        this.parent = parent;
    }

    public Namespace cloneNamespace() {
        return new Namespace(this.namespaceModule, this.parent != null ? this.parent.cloneNamespace() : null);
    }

    public Namespace getParent() {
        return this.parent;
    }

    public RubyModule getNamespaceModule() {
        return this.namespaceModule;
    }

    public IRubyObject getConstant(IRubyObject self, String name) {
        Namespace ns = this;
        while (ns != null && ns.getParent() != null) {
            if (ns.getNamespaceModule() == null) {
                return self.getMetaClass().getConstant(name);
            }
            if (ns.getNamespaceModule().hasInstanceVariable(name)) {
                return ns.getNamespaceModule().getInstanceVariable(name);
            }
            ns = ns.getParent();
        }
        return this.getNamespaceModule().getConstant(name);
    }
}

