/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.runtime.Arity;
import org.jruby.runtime.Callback;
import org.jruby.runtime.IStaticCallable;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public final class StaticCallback
implements Callback {
    final IStaticCallable callable;
    final int index;
    final Arity arity;

    private StaticCallback(IStaticCallable callable, int index, Arity arity) {
        this.callable = callable;
        this.index = index;
        this.arity = arity;
    }

    public static StaticCallback createOptional(IStaticCallable callable, int index, int minimum) {
        Asserts.isTrue(minimum >= 0);
        return new StaticCallback(callable, index, Arity.required(minimum));
    }

    public static StaticCallback createOptional(IStaticCallable callable, int index) {
        return new StaticCallback(callable, index, Arity.optional());
    }

    public static StaticCallback create(IStaticCallable callable, int index, int arity) {
        return new StaticCallback(callable, index, Arity.fixed(arity));
    }

    public IRubyObject execute(IRubyObject receiver, IRubyObject[] args) {
        this.arity.checkArity(receiver.getRuntime(), args);
        return this.callable.callIndexed(this.index, receiver, args);
    }

    public Arity getArity() {
        return this.arity;
    }
}

