/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.exceptions.ArgumentError;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalCache;
import org.jruby.util.Asserts;

public class UnmarshalStream
extends FilterInputStream {
    protected final Ruby runtime;
    private UnmarshalCache cache;

    public UnmarshalStream(Ruby runtime, InputStream in) throws IOException {
        super(in);
        this.runtime = runtime;
        this.cache = new UnmarshalCache(runtime);
        in.read();
        in.read();
    }

    public IRubyObject unmarshalObject() throws IOException {
        int type = this.readUnsignedByte();
        IRubyObject result = this.cache.isLinkType(type) ? this.cache.readLink(this, type) : this.unmarshalObjectDirectly(type);
        return result;
    }

    public void registerLinkTarget(IRubyObject newObject) {
        this.cache.register(newObject);
    }

    private IRubyObject unmarshalObjectDirectly(int type) throws IOException {
        switch (type) {
            case 48: {
                return this.runtime.getNil();
            }
            case 84: {
                return RubyBoolean.newBoolean(this.runtime, true);
            }
            case 70: {
                return RubyBoolean.newBoolean(this.runtime, false);
            }
            case 34: {
                return RubyString.unmarshalFrom(this);
            }
            case 105: {
                return RubyFixnum.unmarshalFrom(this);
            }
            case 58: {
                return RubySymbol.unmarshalFrom(this);
            }
            case 91: {
                return RubyArray.unmarshalFrom(this);
            }
            case 123: {
                return RubyHash.unmarshalFrom(this);
            }
            case 99: {
                return RubyClass.unmarshalFrom(this);
            }
            case 109: {
                return RubyModule.unmarshalFrom(this);
            }
            case 108: {
                return RubyBignum.unmarshalFrom(this);
            }
            case 83: {
                return RubyStruct.unmarshalFrom(this);
            }
            case 111: {
                return this.defaultObjectUnmarshal();
            }
            case 117: {
                return this.userUnmarshal();
            }
        }
        throw new ArgumentError(this.getRuntime(), "dump format error(" + type + ")");
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public int readUnsignedByte() throws IOException {
        int result = this.read();
        if (result == -1) {
            throw new IOException("Unexpected end of stream");
        }
        return result;
    }

    public byte readSignedByte() throws IOException {
        int b = this.readUnsignedByte();
        if (b > 127) {
            return (byte)(b - 256);
        }
        return (byte)b;
    }

    public String unmarshalString() throws IOException {
        int length = this.unmarshalInt();
        byte[] buffer = new byte[length];
        int bytesRead = this.read(buffer);
        if (bytesRead != length) {
            throw new IOException("Unexpected end of stream");
        }
        return RubyString.bytesToString(buffer);
    }

    public int unmarshalInt() throws IOException {
        long result;
        int c = this.readSignedByte();
        if (c == 0) {
            return 0;
        }
        if (4 < c && c < 128) {
            return c - 5;
        }
        if (-129 < c && c < -4) {
            return c + 5;
        }
        if (c > 0) {
            result = 0L;
            int i = 0;
            while (i < c) {
                result |= (long)this.readUnsignedByte() << 8 * i;
                ++i;
            }
        } else {
            c = -c;
            result = -1L;
            int i = 0;
            while (i < c) {
                result &= 255L << 8 * i ^ 0xFFFFFFFFFFFFFFFFL;
                result |= (long)this.readUnsignedByte() << 8 * i;
                ++i;
            }
        }
        return (int)result;
    }

    private IRubyObject defaultObjectUnmarshal() throws IOException {
        RubySymbol className = (RubySymbol)this.unmarshalObject();
        RubyClass type = (RubyClass)this.runtime.getClasses().getClassFromPath(className.asSymbol());
        Asserts.notNull(type, "type shouldn't be null.");
        IRubyObject result = this.runtime.getFactory().newObject(type);
        this.registerLinkTarget(result);
        int i = 0;
        int count = this.unmarshalInt();
        while (i < count) {
            result.setInstanceVariable(this.unmarshalObject().asSymbol(), this.unmarshalObject());
            ++i;
        }
        return result;
    }

    private IRubyObject userUnmarshal() throws IOException {
        String className = ((RubySymbol)this.unmarshalObject()).asSymbol();
        String marshaled = this.unmarshalString();
        RubyModule classInstance = this.runtime.getRubyModule(className);
        IRubyObject result = classInstance.callMethod("_load", RubyString.newString(this.runtime, marshaled));
        this.registerLinkTarget(result);
        return result;
    }
}

