/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.regexp;

import org.jruby.Ruby;
import org.jruby.exceptions.RegexpError;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class IRegexpAdapter {
    private static final String[] REGEXP_ADAPTER = new String[]{"org.jruby.runtime.regexp.JDKRegexpAdapter", "org.jruby.runtime.regexp.GNURegexpAdapter", "org.jruby.runtime.regexp.ORORegexpAdapter"};
    private static final String[] SHORT_NAMES = new String[]{"JDK", "GNU", "ORO"};

    public static Class getAdapter(String shortName) {
        if (shortName == null) {
            int i = 0;
            while (i < REGEXP_ADAPTER.length) {
                try {
                    return Class.forName(REGEXP_ADAPTER[i]);
                }
                catch (ClassNotFoundException cnfExcptn) {
                }
                catch (NoClassDefFoundError ncdfError) {
                    // empty catch block
                }
                ++i;
            }
            throw new RuntimeException("No regexp adapter found.");
        }
        try {
            shortName = shortName.toUpperCase();
            int i = 0;
            while (i < SHORT_NAMES.length) {
                if (shortName.equals(SHORT_NAMES[i])) {
                    return Class.forName(REGEXP_ADAPTER[i]);
                }
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        throw new RuntimeException("No regexp adapter found: " + shortName);
    }

    public abstract void compile(Ruby var1, String var2) throws RegexpError;

    public abstract void setCasefold(boolean var1);

    public abstract boolean getCasefold();

    public abstract void setExtended(boolean var1);

    public abstract void setMultiline(boolean var1);

    public abstract IRubyObject search(Ruby var1, String var2, int var3);

    public String unextend(String re) {
        boolean inClass = false;
        int len = re.length();
        StringBuffer sbuf = new StringBuffer(len);
        int pos = 0;
        while (pos < len) {
            char c = re.charAt(pos);
            if (c == '\\' && ++pos < len) {
                sbuf.append('\\').append(re.charAt(pos));
            } else if (c == '[' && ++pos < len) {
                sbuf.append(c);
                inClass = true;
                c = re.charAt(pos);
                if (c == ']') {
                    sbuf.append(c);
                }
            } else if (c == ']') {
                sbuf.append(c);
                inClass = false;
            } else if (c == '#') {
                if (pos > 2 && re.charAt(pos - 2) == '(' && re.charAt(pos - 1) == '?') {
                    sbuf.append(c);
                } else {
                    ++pos;
                    while (pos < len && re.charAt(pos) != '\n' && re.charAt(pos) != '\r') {
                        ++pos;
                    }
                }
            } else if (inClass || !Character.isWhitespace(c)) {
                sbuf.append(c);
            }
            ++pos;
        }
        return sbuf.toString();
    }
}

