/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import org.ablaf.ast.IAstDecoder;
import org.ablaf.ast.INode;
import org.jruby.Ruby;
import org.jruby.ast.util.RubyAstMarshal;
import org.jruby.exceptions.IOError;
import org.jruby.runtime.load.Library;

public class BuiltinScript
implements Library {
    private final String name;

    public BuiltinScript(String name) {
        this.name = name;
    }

    public void load(Ruby runtime) {
        runtime.loadNode("jruby builtin", this.getNode(runtime), false);
    }

    private INode getNode(Ruby runtime) {
        String resourceName = "/builtin/" + this.name + ".rb.ast.ser";
        InputStream in = this.getClass().getResourceAsStream(resourceName);
        if (in == null) {
            throw new IOError(runtime, "Resource not found: " + resourceName);
        }
        in = new BufferedInputStream(in);
        IAstDecoder decoder = RubyAstMarshal.getInstance().openDecoder(in);
        INode result = decoder.readNode();
        decoder.close();
        return result;
    }
}

