/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.ArrayList;
import java.util.List;
import org.jruby.Main;

public class CommandlineParser {
    private final String[] arguments;
    public String sRegexpAdapter;
    private ArrayList loadPaths = new ArrayList();
    private StringBuffer inlineScript = new StringBuffer();
    public String scriptFileName = null;
    private ArrayList requiredLibraries = new ArrayList();
    public boolean isBenchmarking = false;
    public boolean assumeLoop = false;
    public boolean assumePrinting = false;
    public boolean processLineEnds = false;
    public boolean sDoSplit = false;
    public boolean verbose = false;
    public boolean showVersion = false;
    public String[] scriptArguments = null;
    private boolean shouldRunInterpreter = true;
    public int argumentIndex = 0;
    public int characterIndex = 0;

    public CommandlineParser(String[] arguments) {
        this.arguments = arguments;
        this.processArguments();
    }

    private void processArguments() {
        while (this.argumentIndex < this.arguments.length && CommandlineParser.isInterpreterArgument(this.arguments[this.argumentIndex])) {
            this.processArgument();
            ++this.argumentIndex;
        }
        if (this.inlineScript.length() == 0 && this.argumentIndex < this.arguments.length) {
            this.scriptFileName = this.arguments[this.argumentIndex];
            ++this.argumentIndex;
        }
        this.scriptArguments = new String[this.arguments.length - this.argumentIndex];
        System.arraycopy(this.arguments, this.argumentIndex, this.scriptArguments, 0, this.scriptArguments.length);
    }

    private static boolean isInterpreterArgument(String argument) {
        return argument.charAt(0) == '-';
    }

    private void processArgument() {
        String argument = this.arguments[this.argumentIndex];
        this.characterIndex = 1;
        block15: while (this.characterIndex < argument.length()) {
            switch (argument.charAt(this.characterIndex)) {
                case 'h': {
                    Main.printUsage();
                    break;
                }
                case 'I': {
                    this.loadPaths.add(this.grabValue(" -I must be followed by a directory name to add to lib path"));
                    break block15;
                }
                case 'r': {
                    this.requiredLibraries.add(this.grabValue("-r must be followed by a package to require"));
                    break block15;
                }
                case 'e': {
                    this.inlineScript.append(this.grabValue(" -e must be followed by an expression to evaluate"));
                    this.inlineScript.append('\n');
                    break block15;
                }
                case 'b': {
                    this.isBenchmarking = true;
                    break;
                }
                case 'R': {
                    this.sRegexpAdapter = this.grabValue(" -R must be followed by an expression to evaluate");
                    break block15;
                }
                case 'p': {
                    this.assumePrinting = true;
                    this.assumeLoop = true;
                    break;
                }
                case 'n': {
                    this.assumeLoop = true;
                    break;
                }
                case 'a': {
                    this.sDoSplit = true;
                    break;
                }
                case 'l': {
                    this.processLineEnds = true;
                    break;
                }
                case 'v': {
                    this.showVersion = true;
                    this.verbose = true;
                    break;
                }
                case 'w': {
                    this.verbose = true;
                    break;
                }
                case '-': {
                    if (argument.equals("--version")) {
                        this.showVersion = true;
                        this.shouldRunInterpreter = false;
                        break block15;
                    }
                }
                default: {
                    System.err.println("unknown option " + argument.charAt(this.characterIndex));
                    System.exit(1);
                }
            }
            ++this.characterIndex;
        }
    }

    private String grabValue(String errorMessage) {
        ++this.characterIndex;
        if (this.characterIndex < this.arguments[this.argumentIndex].length()) {
            return this.arguments[this.argumentIndex].substring(this.characterIndex);
        }
        ++this.argumentIndex;
        if (this.argumentIndex < this.arguments.length) {
            return this.arguments[this.argumentIndex];
        }
        System.err.println("invalid argument " + this.argumentIndex);
        System.err.println(errorMessage);
        Main.printUsage();
        System.exit(1);
        return null;
    }

    public boolean hasInlineScript() {
        return this.inlineScript.length() > 0;
    }

    public String inlineScript() {
        return this.inlineScript.toString();
    }

    public List requiredLibraries() {
        return this.requiredLibraries;
    }

    public List loadPaths() {
        return this.loadPaths;
    }

    public boolean shouldRunInterpreter() {
        return this.shouldRunInterpreter;
    }
}

