// -*- C++ -*-
//
// $Id: mpi2c++_map.h,v 1.3 2001/12/15 02:42:42 jsquyres Exp $
//
// $COPYRIGHT$
//

#ifndef MPI2CPP_MAP_H_
#define MPI2CPP_MAP_H_

#include "mpi2c++/mpi2c++_list.h"
typedef mpi2cppList mpi2cppContainer;

template <class TYPE1, class TYPE2>
class mpi2cppMap {
  mpi2cppContainer c;
public:

  typedef TYPE1 key_t;
  typedef TYPE2 value_t;
  typedef mpi2cppList::iter iter;

  struct Pair {
    Pair(key_t f, value_t s) : first(f), second(s) {}
    Pair() : first((key_t) 0), second((value_t) 0) { }
    key_t first;
    value_t second;
  };

  mpi2cppMap() { }

  ~mpi2cppMap() {
    for (iter i = c.begin(); i != c.end(); i++) {
      delete (Pair*)(*i);
    }
  }
  
  Pair* begin();
  Pair* end();
  
  value_t& operator[](key_t key)
  {
    value_t* found = (value_t*)0;
    for (iter i = c.begin(); i != c.end(); i++) {
      if (((Pair*)*i)->first == key)
	found = &((Pair*)*i)->second;
    }
    if (! found) {
      iter tmp = c.insert(c.begin(), new Pair(key, (value_t) 0));
      found = &((Pair*)*tmp)->second;
    }
    return *found;
  }

  void erase(key_t key)
  {
    for (iter i = c.begin(); i != c.end(); i++) {
      if (((Pair*)*i)->first == key) {
	delete (Pair*)*i;
	c.erase(i); break;
      }
    }
  }
};

#endif




