// -*- c++ -*-
//
// $Id: topology.h,v 1.3 2001/12/15 02:42:42 jsquyres Exp $
//
// $COPYRIGHT$
//


class Cartcomm : public Intracomm {
public:

  // construction
  Cartcomm() { }
  // copy
  Cartcomm(const Comm_Null& data) : Intracomm(data) { }
  // inter-language operability
  inline Cartcomm(const MPI_Comm& data);
#if _MPIPP_PROFILING_
  Cartcomm(const Cartcomm& data) : pmpi_comm(data), Intracomm(data) { }
  Cartcomm(const PMPI::Cartcomm& d) : pmpi_comm(d), Intracomm((const PMPI::Intracomm&)d) { }
  
  // assignment
  Cartcomm& operator=(const Cartcomm& data) {
    Intracomm::operator=(data);
    pmpi_comm = data.pmpi_comm; return *this; }
  Cartcomm& operator=(const Comm_Null& data) {
    Intracomm::operator=(data);
    pmpi_comm = (PMPI::Cartcomm)data; return *this; }
  // inter-language operability
  Cartcomm& operator=(const MPI_Comm& data) {
    Intracomm::operator=(data);
    pmpi_comm = data; return *this; }
#else
  Cartcomm(const Cartcomm& data) : Intracomm(data.mpi_comm) { }
  // assignment
  Cartcomm& operator=(const Cartcomm& data) {
    mpi_comm = data.mpi_comm; return *this; }
  Cartcomm& operator=(const Comm_Null& data) {
    mpi_comm = data; return *this; }
  // inter-language operability
  Cartcomm& operator=(const MPI_Comm& data) {
    mpi_comm = data; return *this; } 
#endif
  //
  // Groups, Contexts, and Communicators
  //

  Cartcomm Dup() const;

  virtual
#if MPI2CPP_VIRTUAL_FUNC_RET
  Cartcomm&
#else
  Comm&
#endif
  Clone() const;


  //
  // Groups, Contexts, and Communicators
  //

  virtual int Get_dim() const;

  virtual void Get_topo(int maxdims, int dims[], MPI2CPP_BOOL_T periods[],
			int coords[]) const;

  virtual int Get_cart_rank(const int coords[]) const;

  virtual void Get_coords(int rank, int maxdims, int coords[]) const;

  virtual void Shift(int direction, int disp,
		     int &rank_source, int &rank_dest) const;
  
  virtual Cartcomm Sub(const MPI2CPP_BOOL_T remain_dims[]);

  virtual int Map(int ndims, const int dims[], const MPI2CPP_BOOL_T periods[]) const;

#if _MPIPP_PROFILING_
private:
  PMPI::Cartcomm pmpi_comm;
#endif
};


//===================================================================
//                    Class Graphcomm
//===================================================================

class Graphcomm : public Intracomm {
public:

  // construction
  Graphcomm() { }
  // copy
  Graphcomm(const Comm_Null& data) : Intracomm(data) { }
  // inter-language operability
  inline Graphcomm(const MPI_Comm& data);
#if _MPIPP_PROFILING_
  Graphcomm(const Graphcomm& data) : pmpi_comm(data), Intracomm(data) { }
  Graphcomm(const PMPI::Graphcomm& d) : pmpi_comm(d), Intracomm((const PMPI::Intracomm&)d) { }
  
  // assignment
  Graphcomm& operator=(const Graphcomm& data) {
    Intracomm::operator=(data);
    pmpi_comm = data.pmpi_comm; return *this; }
  Graphcomm& operator=(const Comm_Null& data) {
    Intracomm::operator=(data);
    pmpi_comm = (PMPI::Graphcomm)data; return *this; }
  // inter-language operability
  Graphcomm& operator=(const MPI_Comm& data) {
    Intracomm::operator=(data);
    pmpi_comm = data; return *this; }

#else
  Graphcomm(const Graphcomm& data) : Intracomm(data.mpi_comm) { }
  // assignment
  Graphcomm& operator=(const Graphcomm& data) {
    mpi_comm = data.mpi_comm; return *this; }
  Graphcomm& operator=(const Comm_Null& data) {
    mpi_comm = data; return *this; }
  // inter-language operability
  Graphcomm& operator=(const MPI_Comm& data) {
    mpi_comm = data; return *this; } 
#endif

  //
  // Groups, Contexts, and Communicators
  //
  
  Graphcomm Dup() const;

  virtual
#if MPI2CPP_VIRTUAL_FUNC_RET  
  Graphcomm&
#else
  Comm&
#endif
  Clone() const;

  //
  //  Process Topologies
  //

  virtual void Get_dims(int nnodes[], int nedges[]) const;

  virtual void Get_topo(int maxindex, int maxedges, int index[], 
			int edges[]) const;

  virtual int Get_neighbors_count(int rank) const;

  virtual void Get_neighbors(int rank, int maxneighbors, 
			     int neighbors[]) const;

  virtual int Map(int nnodes, const int index[], 
		  const int edges[]) const;

#if _MPIPP_PROFILING_
private:
  PMPI::Graphcomm pmpi_comm;
#endif
};

