/*en    Laurent Constantin's network library (lcrzo)
 */
/*fr    Bibliotheque reseau de Laurent Constantin (lcrzo)
 */

#ifndef LCRZO_INCLUDED
#define LCRZO_INCLUDED 1

/*en defines created during library's compilation*/
/*fr defines crees lors de la compilation de la bibliotheque*/
#include "lcrzo_defs.h"

/*en define also Unix */
/*fr definit aussi Unix */
#if defined LCRZODEF_SYSTEM_Linux || defined LCRZODEF_SYSTEM_FreeBSD || defined LCRZODEF_SYSTEM_OpenBSD || defined LCRZODEF_SYSTEM_Solaris || defined LCRZODEF_SYSTEM_MacOS
 #define LCRZODEF_SYSTEM_Unix 1
#elif defined LCRZODEF_SYSTEM_Windows
#else
 #error "Unknown value for LCRZODEF_SYSTEM"
#endif

/*en standard types*/
/*fr types standard*/
#include "lcrzo_types.h"

/*-------------------------------------------------------------*/
/*EN                     FUNCTIONS FROM EACH MODULE              */
/*FR                     FONCTIONS DE CHAQUE MODULE              */
/*-------------------------------------------------------------*/
/*en fonctions dealing with data arrays*/
/*fr fonctions de gestion de tableaux de donnees*/
#include "lcrzo_data.h"
/*en fonctions dealing with strings and regulars expressions*/
/*fr fonctions traitant des chaines de caracteres*/
#include "lcrzo_string.h"
/*en fonctions measuring time, and waiting*/
/*fr fonctions permettant de mesurer le temps, et d'attendre*/
#include "lcrzo_time.h"
/*en fonctions dealing with files*/
/*fr fonctions traitant des fichiers*/
#include "lcrzo_file.h"
/*en fonctions creating and converting addresses*/
/*fr fonctions de creation et de conversion d'adresse*/
#include "lcrzo_address.h"
/*en fonctions dealing with devices*/
/*fr fonctions de gestion des devices*/
#include "lcrzo_device.h"
/*en fonctions dealing with generic lists*/
/*fr fonctions traitant des listes generiques*/
#include "lcrzo_list.h"
/*en fonctions dealing with processes*/
/*fr fonctions de gestion des processus*/
#include "lcrzo_process.h"
/*en fonctions dealing with Inter Process Communication*/
/*fr fonctions permettant de transferer des donnees entre processus*/
#include "lcrzo_ipc.h"
/**/
/*en fonctions allowing header creation*/
/*fr fonctions de creation d'entetes*/
#include "lcrzo_header.h"
/*en fonctions creating and decoding/analyzing IP options*/
/*fr fonctions de creation d'options IP*/
#include "lcrzo_ipopt.h"
/*en fonctions creating and decoding/analyzing TCP options*/
/*fr fonctions de creation d'options TCP*/
#include "lcrzo_tcpopt.h"
/*en fonctions creating and decoding/analyzing packets*/
/*fr fonctions de creation et decomposition de paquets*/
#include "lcrzo_packet.h"
/*en fonctions creating and decoding/analyzing ICMP packets*/
/*fr fonctions de creation et decomposition de paquets ICMP*/
#include "lcrzo_icmp.h"
/*en fonctions printing data and packets*/
/*fr fonctions ecrivant les donnees*/
#include "lcrzo_print.h"
/*en fonctions saving an restoring packets*/
/*fr fonctions de sauvegarde/restitution de paquets*/
#include "lcrzo_record.h"
/*en fonctions dealing with configuration of the computer*/
/*fr fonctions de gestion de la configuration*/
#include "lcrzo_conf.h"
/*en fonctions sending packets*/
/*fr fonctions d'envoi de paquets*/
#include "lcrzo_spoof.h"
/*en fonctions sniffing packets*/
/*fr fonctions de sniff de paquets*/
#include "lcrzo_sniff.h"
/*en fonctions dealing with real/virtual clients/servers*/
/*fr fonctions client/serveurs reels et virtuels*/
#include "lcrzo_sock.h"
/*en fonctions to wait for data to be read*/
/*fr fonctions pour attendre la disponibilite de donnees*/
#include "lcrzo_wait.h"
/*en fonctions dealing with global configuration and parameters*/
/*fr fonctions de parametres globaux*/
#include "lcrzo_global.h"
/*en error codes*/
/*fr codes d'erreur*/
#include "lcrzo_error.h"
/*en miscellaneous fonctions*/
/*fr fonctions diverses*/
#include "lcrzo_misc.h"
/*en obsolete fonctions*/
/*fr fonctions obsoletes*/
#include "lcrzo_obso.h"

#endif /*ifndef LCRZO_INCLUDED*/
