/*en    Laurent Constantin's network library (lcrzo)
                   lcrzo_obso module

  Functions herein are considered a obsolete. They may not be supported
  in later versions.
*/
/*fr    Bibliotheque reseau de Laurent Constantin (lcrzo)
                      Module lcrzo_obso

  Les fonctions presentes dans ce module sont obsoletes. Elles ne seront
  peut etre plus supportees dans les prochaines versions de lcrzo.
*/

#define LCRZO_OBSOLETE_REJECT 0
#if LCRZO_OBSOLETE_REJECT==0

/*-------------------------------------------------------------*/
/*EN                      OBSOLETED IN 4.05                    */
/*FR               OBSOLETE DEPUIS LA VERSION 4.05             */
/*-------------------------------------------------------------*/

/* Why physical headers are obsoleted ?
    - when porting on new architecture, we encounter problems
      because items might not be packed
    - when porting on new architecture, we encounter problems
      because item order depends on compiler and optimization
    - bitfields implementation are not standardized
   So, I'll try to support those types everywhere, however, 
   as it might not be possible in the future, you should not use
   lcrzo_hdrpxxx anymore.
   What to use now ?
     lcrzo_hdrpxxx2. See lcrzo_header.h.
 */

/*-------------------------------------------------------------*/
/*en physical header for ethernet header*/
/*fr entete physique de paquet ethernet */
typedef struct
{ lcrzo_etha   dst;
  lcrzo_etha   src;
  lcrzo_uint16 type;
} lcrzo_hdrpeth;
/*en convert from logical header to physical header */
/*fr conversion d'entete logique a physique */
int lcrzo_hdrpeth_init_hdrleth(lcrzo_hdrleth hdrleth,
			       lcrzo_hdrpeth *phdrpeth);
/*en convert from physical header to logical header */
/*fr conversion d'entete physique a logique */
int lcrzo_hdrleth_init_hdrpeth(lcrzo_hdrpeth hdrpeth,
			       lcrzo_hdrleth *phdrleth);

/*-------------------------------------------------------------*/
/*en physical header for IP header*/
/*fr entete physique de paquet IP */
#if LCRZODEF_ENDIANLITTLE==1
typedef struct 
{ unsigned int ihl:4; 
  unsigned int version:4;
  unsigned int tos:8;
  unsigned int totlen:16;
  lcrzo_uint16 id;
  lcrzo_uint16 fragoff;
  lcrzo_uint8  ttl;
  lcrzo_uint8  protocol;
  lcrzo_uint16 check;
  lcrzo_uint32 saddr;
  lcrzo_uint32 daddr;
} lcrzo_hdrpip;
#elif LCRZODEF_ENDIANBIG==1
typedef struct 
{ unsigned int version:4;
  unsigned int ihl:4;
  unsigned int tos:8;
  unsigned int totlen:16;
  lcrzo_uint16 id;
  lcrzo_uint16 fragoff;
  lcrzo_uint8  ttl;
  lcrzo_uint8  protocol;
  lcrzo_uint16 check;
  lcrzo_uint32 saddr;
  lcrzo_uint32 daddr;
} lcrzo_hdrpip;
#endif
/*en these defines permit to access to fragment bits */
/*fr les defines suivants permettent d'acceder aux bits de fragment*/
/*enreserved*/
/*frreserve*/
#define LCRZO_HDRPIP_RF_NH(i)  ((lcrzo_int8)((lcrzo_ntohs(i)&0x8000)>>15))
#define LCRZO_HDRPIP_RF_HN(i)  (lcrzo_htons( (1&(i))<<15 ))
/*dontfrag*/
#define LCRZO_HDRPIP_DF_NH(i)  ((lcrzo_int8)((lcrzo_ntohs(i)&0x4000)>>14))
#define LCRZO_HDRPIP_DF_HN(i)  (lcrzo_htons( (1&(i))<<14 ))
/*morefrag*/
#define LCRZO_HDRPIP_MF_NH(i)  ((lcrzo_int8)((lcrzo_ntohs(i)&0x2000)>>13))
#define LCRZO_HDRPIP_MF_HN(i)  (lcrzo_htons( (1&(i))<<13 ))
/*offset*/
#define LCRZO_HDRPIP_OFF_NH(i) ((lcrzo_uint16)(lcrzo_ntohs(i)&0x1FFF))
#define LCRZO_HDRPIP_OFF_HN(i) (lcrzo_htons( 0x1FFF&(i)  ))
/*en convert from logical header to physical header */
/*fr conversion d'entete logique a physique */
int lcrzo_hdrpip_init_hdrlip(lcrzo_hdrlip hdrlip,
			     lcrzo_hdrpip *phdrpip);
/*en convert from physical header to logical header */
/*fr conversion d'entete physique a logique */
int lcrzo_hdrlip_init_hdrpip(lcrzo_hdrpip hdrpip,
			     lcrzo_hdrlip *phdrlip);

/*-------------------------------------------------------------*/
/*en physical header for UDP header*/
/*fr entete physique de paquet UDP */
typedef struct
{ lcrzo_uint16 sport;
  lcrzo_uint16 dport;
  lcrzo_uint16 len;
  lcrzo_uint16 check;
} lcrzo_hdrpudp;
/*en convert from logical header to physical header */
/*fr conversion d'entete logique a physique */
int lcrzo_hdrpudp_init_hdrludp(lcrzo_hdrludp hdrludp,
			       lcrzo_hdrpudp *phdrpudp);
/*en convert from physical header to logical header */
/*fr conversion d'entete physique a logique */
int lcrzo_hdrludp_init_hdrpudp(lcrzo_hdrpudp hdrpudp,
			       lcrzo_hdrludp *phdrludp);

/*-------------------------------------------------------------*/
/*en physical header for TCP header*/
/*fr entete physique de paquet TCP */
#if LCRZODEF_ENDIANLITTLE==1
typedef struct
{
  lcrzo_uint16 sport;
  lcrzo_uint16 dport;
  lcrzo_uint32 seqnum;
  lcrzo_uint32 acknum;
  unsigned int res1:4;
  unsigned int doff:4;
  unsigned int fin:1;
  unsigned int syn:1;
  unsigned int rst:1;
  unsigned int psh:1;
  unsigned int ack:1;
  unsigned int urg:1;
  unsigned int res2:2;
  unsigned int window:16;
  lcrzo_uint16 check;
  lcrzo_uint16 urgptr;
} lcrzo_hdrptcp;
#elif LCRZODEF_ENDIANBIG==1
typedef struct
{
  lcrzo_uint16 sport;
  lcrzo_uint16 dport;
  lcrzo_uint32 seqnum;
  lcrzo_uint32 acknum;
  unsigned int doff:4;
  unsigned int res1:4;
  unsigned int res2:2;
  unsigned int urg:1;
  unsigned int ack:1;
  unsigned int psh:1;
  unsigned int rst:1;
  unsigned int syn:1;
  unsigned int fin:1;
  unsigned int window:16;
  lcrzo_uint16 check;
  lcrzo_uint16 urgptr;
} lcrzo_hdrptcp;
#endif
/*en convert from logical header to physical header */
/*fr conversion d'entete logique a physique */
int lcrzo_hdrptcp_init_hdrltcp(lcrzo_hdrltcp hdrltcp,
			       lcrzo_hdrptcp *phdrptcp);
/*en convert from physical header to logical header */
/*fr conversion d'entete physique a logique */
int lcrzo_hdrltcp_init_hdrptcp(lcrzo_hdrptcp hdrptcp,
			       lcrzo_hdrltcp *phdrltcp);

/*-------------------------------------------------------------*/
/*en physical header for ICMP header*/
/*fr entete physique de paquet ICMP */
typedef struct
{ lcrzo_uint8  type;
  lcrzo_uint8  code;
  lcrzo_uint16 check;
} lcrzo_hdrpicmp;
/*en convert from logical header to physical header */
/*fr conversion d'entete logique a physique */
int lcrzo_hdrpicmp_init_hdrlicmp(lcrzo_hdrlicmp hdrlicmp,
				 lcrzo_hdrpicmp *phdrpicmp);
/*en convert from physical header to logical header */
/*fr conversion d'entete physique a logique */
int lcrzo_hdrlicmp_init_hdrpicmp(lcrzo_hdrpicmp hdrpicmp,
				 lcrzo_hdrlicmp *phdrlicmp);

/*-------------------------------------------------------------*/
/*en physical header for ARP/RARP header*/
/*fr entete physique de paquet ARP/RARP */
typedef struct
{ lcrzo_uint16 hw_type;    /*1:ethernet 10/100Mbps*/
  lcrzo_uint16 prot_type;  /*0x0800:ip*/
  lcrzo_uint8  hw_size;    /*6*/
  lcrzo_uint8  prot_size;  /*4*/
  lcrzo_uint16 op;         /*1:arpreq,2:arpreply, 3:rarpreq,4:rarpreply*/
  lcrzo_etha   hw_src;
  lcrzo_ipa    prot_src;
  lcrzo_etha   hw_dst;
  lcrzo_ipa    prot_dst;
} lcrzo_hdrparp;
/*en convert from logical header to physical header */
/*fr conversion d'entete logique a physique */
int lcrzo_hdrparp_init_hdrlarp(lcrzo_hdrlarp hdrlarp,
			       lcrzo_hdrparp *phdrparp);
/*en convert from physical header to logical header */
/*fr conversion d'entete physique a logique */
int lcrzo_hdrlarp_init_hdrparp(lcrzo_hdrparp hdrparp,
			       lcrzo_hdrlarp *phdrlarp);


/*-------------------------------------------------------------*/
/*EN                      OBSOLETED IN 4.06                    */
/*FR               OBSOLETE DEPUIS LA VERSION 4.06             */
/*-------------------------------------------------------------*/

/* Why are they obsoleted ?
   Because now lcrzo supports loopback and ppp
*/

int lcrzo_conf_devices_add_user_406(lcrzo_bool priorityoversystem,
				    lcrzo_constdevice device,
				    lcrzo_constetha etha,
				    lcrzo_ipl ipl,
				    lcrzo_ipl netmask,
				    lcrzo_uint32 mtu,
				    lcrzo_bool isup,
				    lcrzo_bool isanalias);
int lcrzo_conf_devices_del_system_406(lcrzo_constdevice device,
				      lcrzo_constetha etha,
				      lcrzo_ipl ipl);
int lcrzo_conf_devices_del_user_406(lcrzo_constdevice device,
				    lcrzo_constetha etha,
				    lcrzo_ipl ipl);
int lcrzo_conf_devices_value_pos_406(lcrzo_int32 pos,
				     lcrzo_device device,
				     lcrzo_etha etha,
				     lcrzo_ipl *pipl,
				     lcrzo_ipl *pnetmask,
				     lcrzo_uint32 *pmtu,
				     lcrzo_bool *pisup,
				     lcrzo_bool *pisanalias);

/*-------------------------------------------------------------*/
/*EN                      OBSOLETED IN 4.10                    */
/*FR               OBSOLETE DEPUIS LA VERSION 4.10             */
/*-------------------------------------------------------------*/

/* Why are they obsoleted ?
   Because now free set pointer in order to detect usage after
   free.
*/
int lcrzo_data_free(lcrzo_data ptr);
int lcrzo_string_free(lcrzo_string ptr);

/*-------------------------------------------------------------*/
/* Why are they obsoleted ?
   Because they lead to complicated programs for nothing.
*/
/* if (z!=LCRZO_ERR_OK) { f; return(z) } */
#define lcrzo_efr(z,f) {int lcrzo_coderr=z;if(lcrzo_coderr!=LCRZO_ERR_OK){f;return(lcrzo_coderr);}}
/* if (z!=LCRZO_ERR_OK) { lcrzo_err_print(z); f; return(z) } */
#define lcrzo_epfr(z,f) {int lcrzo_coderr=z;if(lcrzo_coderr!=LCRZO_ERR_OK){lcrzo_err_print(lcrzo_coderr);f;return(lcrzo_coderr);}}
/* lcrzo_err_print(z); if (z!=LCRZO_ERR_OK) { f; return(z) } */
#define lcrzo_evfr(z,f) {int lcrzo_coderr=z;lcrzo_err_print(lcrzo_coderr);if(lcrzo_coderr!=LCRZO_ERR_OK){f;return(lcrzo_coderr);}}
/* if (z!=i) { f; return(z) } */
#define lcrzo_eifr(z,i,f) {int lcrzo_coderr=z;if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK)return(LCRZO_ERR_IEOKKO);f;return(lcrzo_coderr);}}
/* if (z!=i) { lcrzo_err_print(z); f; return(z) } */
#define lcrzo_eipfr(z,i,f) {int lcrzo_coderr=z;if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK){lcrzo_err_print(LCRZO_ERR_IEOKKO);f;return(LCRZO_ERR_IEOKKO);}lcrzo_err_print(lcrzo_coderr);f;return(lcrzo_coderr);}}
/* lcrzo_err_print(z); if (z!=i) { f; return(z) } */
#define lcrzo_eivfr(z,i,f) {int lcrzo_coderr=z;lcrzo_err_print(lcrzo_coderr);if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK){f;return(LCRZO_ERR_IEOKKO);}f;return(lcrzo_coderr);}}

/*-------------------------------------------------------------*/
/* Why are they obsoleted ?
   Because we might want to use !LCRZO_FALSE which is ! LCRZO_TRUE.
*/
/*en verify if a lcrzo_bool is 0 or 1 */
/*fr verifie que la valeur d'un lcrzo_bool soit 0 ou 1 */
#define lcrzo_bool_verifbof(i) if((i)!=0&&(i)!=1)return(LCRZO_ERR_PABOOLNOT01)

#endif
