/*en    Laurent Constantin's network library (lcrzo)
                 lcrzo_tcppopt module

  Functions herein allow to create and decode TCP options.
*/
/*fr    Bibliotheque reseau de Laurent Constantin (lcrzo)
                 Module lcrzo_tcpopt

  Les fonctions presentes dans ce module permettent de creer ou
  d'analyser des options TCP.
*/

/*-------------------------------------------------------------*/
/*en define an TCP option type */
/*fr definit un type pour les options TCP */
#define LCRZO_TCPOPT_MAXBYTES 40
typedef lcrzo_uint8 lcrzo_tcpopt[LCRZO_TCPOPT_MAXBYTES];
typedef const lcrzo_tcpopt lcrzo_consttcpopt;

/*en this define permits to verify that there is no buffer overflow
   before setting a lcrzo_tcpopt */
/*fr ce define permet de verifier qu'il n'y ait pas
   de buffer overflow dans un lcrzo_tcpopt */
#define lcrzo_tcpopt_verifbof(nbocttcpopt) if(nbocttcpopt>LCRZO_TCPOPT_MAXBYTES)return(LCRZO_ERR_PAOVERFLOW)

/*-------------------------------------------------------------*/
/*en Name : lcrzo_tcpopt_init_mixed
   Description :
     Initialize an IP option, with data presented 
     in mixed form
   Input parameter(s) :
     mixed : mixed string to use
   Input/output parameter(s) :
   Output parameter(s) :
     tcpopt : lcrzo_tcpopt set with the option
     *ptcpoptsize : size reached by tcpopt
   Normal return values :
     LCRZO_ERR_OK : ok
     LCRZO_ERR_OKDATATRUNCATED : mixed is too long to be put
                                 in tcpopt

*/
/*fr Nom : lcrzo_tcpopt_init_mixed
   Description :
     Initialise un lcrzo_tcpopt par des donnees mixtes
   Parametre(s) d'entree :
     mixed: chaine mixte a utiliser
   Parametre(s) d'entree-sortie :
   Parametre(s) de sortie :
     tcpopt : lcrzo_tcpopt affecte avec l'option
     *ptcpoptsize : taille atteinte par tcpopt
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
     LCRZO_ERR_OKDATATRUNCATED : mixed est trop long pour
                                 etre stocke dans tcpopt
*/
int lcrzo_tcpopt_init_mixed(lcrzo_constmixed mixed,
			    lcrzo_tcpopt tcpopt,
			    lcrzo_uint8 *ptcpoptsize);

/*-------------------------------------------------------------*/
/*en Name : lcrzo_tcpopt_init_stdin
   Description :
     Initialize an IP option, with data presented 
     in mixed form, and entered by the user
   Input parameter(s) :
     message : message to print before asking user
     defaulmixed : mixed string to use if user enters nothing
   Input/output parameter(s) :
   Output parameter(s) :
     tcpopt : lcrzo_tcpopt set with the option
     *ptcpoptsize : size reached by tcpopt
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_tcpopt_init_stdin
   Description :
     Initialise un lcrzo_tcpopt par des donnees mixtes
     entrees par stdin
   Parametre(s) d'entree :
     message : message a afficher avant de demander a
               l'utilisateur l'entrer du mixte
     defaultmixed: chaine mixte a utiliser si l'utilisateur 
                   n'entre rien
   Parametre(s) d'entree-sortie :
   Parametre(s) de sortie :
     tcpopt : lcrzo_tcpopt affecte avec l'option
     *ptcpoptsize : taille atteinte par tcpopt
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_tcpopt_init_stdin(lcrzo_conststring message,
		       lcrzo_constmixed defaultmixed,
		       lcrzo_tcpopt tcpopt,
		       lcrzo_uint8 *ptcpoptsize);
