/*en    Laurent Constantin's network library (lcrzo)
                 lcrzo_type module

  Definitions of standard types.
*/
/*fr    Bibliotheque reseau de Laurent Constantin (lcrzo)
                 Module lcrzo_type

  Definition des types standards.
*/

/*-------------------------------------------------------------*/
/*en integer of 8 bits*/
/*fr definition d'entiers de 8 bits*/
typedef char 		lcrzo_int8;
typedef unsigned char 	lcrzo_uint8;

/*-------------------------------------------------------------*/
/*en integer of 16 bits*/
/*fr definition d'entiers de 16 bits*/
typedef short 		lcrzo_int16;
typedef unsigned short 	lcrzo_uint16;

/*-------------------------------------------------------------*/
/*en integer of 32 bits*/
/*fr definition d'entiers de 32 bits*/
#if defined LCRZODEF_SYSTEMARCH_ia64 || defined LCRZODEF_SYSTEMARCH_alpha
 typedef int 		lcrzo_int32;
 typedef unsigned int 	lcrzo_uint32;
 #define LCRZODEF_INT32_ARELONGS 0
#else
 typedef long 		lcrzo_int32;
 typedef unsigned long 	lcrzo_uint32;
 #define LCRZODEF_INT32_ARELONGS 1
#endif

/*-------------------------------------------------------------*/
/*en maximum size integer on the computer*/
/*fr entier le plus grand sur la machine*/
typedef long            lcrzo_intmax;
typedef unsigned long   lcrzo_uintmax;

/*-------------------------------------------------------------*/
/*en boolean type : 0 or 1*/
/*fr booleen : 0 ou 1*/
#define LCRZO_FALSE 0
#define LCRZO_TRUE  1
typedef unsigned char lcrzo_bool;

/*-------------------------------------------------------------*/
/*en the FILE type is necessary to write to a file. It's defined
   in stdio.h, but I do not want to include ".h" files in lcrzo.
   So, we define LCRZOFILE which has the same utility as FILE*/
/*fr le type FILE est normalement necessaire pour indiquer un fichier.
   Il est defini dans stdio.h, mais je n'ai pas envie de l'inclure
   pour les fichiers ".h" publics de lcrzo. D'un point de vue 
   fonctionnement, le LCRZOFILE ci-dessous est identique a FILE.*/
#define LCRZOFILE void
