#! /bin/sh
# DO NOT EDIT -- generated automatically by subst

set -e

confdir="/usr/local/etc/leafnode"
sbindir="/usr/local/sbin"
sname="leafnode-1"

unset LANG || :
unset LC_ALL || :
unset LC_MESSAGES || :

procs=""

debug() {
 :  printf >&2 "%s" "$1"
}

debugln() {
    debug "$1"
    debug "
"
}

yesno() {
    echo
    echo "$@"
    t='please enter yes or no: '
    ( printf "%s" "$t" ) || ( echo -n "$t" ) || echo "$t"
    read a
    case $a in
	[yY][eE][sS]) return 0 ;;
	[nN][oO]) return 1 ;;
	*) yesno "$@" ;;
    esac
}

daemontools() {
    set -e
    sdir=/service
    test -d $sdir || sdir=/var/service
    test -d $sdir || { echo "cannot find /service directory" ; exit 1; }

    (
    set -e
    umask 027
    cd "$confdir"
    for i in log env ; do 
	if test ! -d $i ; then 
	    mkdir $i
	    chmod 755 $i
	fi
    done
	cp -p run.tcpserver.dist run
	test -f Makefile || cp -p Makefile.dist Makefile
	test -f nntp.rules || cp -p nntp.rules.dist nntp.rules
	make -q nntp.cdb || make nntp.cdb
    chmod 755 run
    test -f env/MAXCONNECTIONS || echo '7

tcpserver will accept at most this many connections at the same time' \
	>env/MAXCONNECTIONS
    test -f env/LISTENIP || echo '127.0.0.1

What own IP leafnode should accept connections on.  This is the address
that your newsreaders must connect to.  Note that only clients on the
same interface as this address will be able to connect.

It must be a local address or 0.

Common are:     (explanation, do not type this in the first line!)
    127.0.0.1   (localhost)
    192.168.0.1 (for example in a LAN)
    0           (to allow connections to any local address)' >env/LISTENIP
    chown root:news env/MAXCONNECTIONS env/LISTENIP
    if test ! -f log/run ; then
	cat <<'_EOF' >log/run
#! /bin/sh
exec logger -p daemon.notice -t leafnode
_EOF
	chmod 755 log/run
    fi
    /command/svok ./. && /command/svc -t ./. || :
    )
    test $? -gt 0 && exit 1

    if test ! -d $sdir/$sname/. ; then
	ln -s "$confdir" $sdir/$sname
	echo "please stand by while svscan rescans its /service directory"
	sleep 6
    fi
    sleep 3
    echo
    echo 'The service should now be "up" for at least two seconds,'
    echo "otherwise, the setup failed. Should you be unable to connect to leafnode,"
    echo "please check the syslog for messages."
    /command/svstat $sdir/$sname/
    return 0
}

cat <<_EOF



*** leafnode setup.sh -- (C) 2002 by Matthias Andree ***

This program is intended to help you configure leafnode for
daemontools/tcpserver.

_EOF

debug "checking for user news... "
id -u news >/dev/null 2>&1 || {
    debugln "not found"
    echo >&2 "Please create a group news and a user news that is only in the news group"
    exit 1
}
debugln "found"

daemontools=0
test -x /command/svscanboot \
&& test -x /command/svscan \
&& test -x /command/envdir \
&& test -x /command/setuidgid \
&& daemontools=1

tcpserver=0
case none in
    */tcpserver*) test -x none && tcpserver=1 ;;
esac

bye=0
if test $daemontools = 0 ; then
    echo >&2 "daemontools is not installed, get it from http://cr.yp.to/daemontools.html"
    bye=1
fi

if test $tcpserver = 0 ; then
    echo >&2 "tcpserver is not installed, get it from http://cr.yp.to/ucspi-tcp.html"
    bye=1
fi

if test $bye = 1 ; then exit 1 ; fi

echo "setting up daemontools run leafnode from tcpserver"
daemontools

echo "finished."
