/////////////////////////////////////////////////////////////////////////////
// File:            gnABISource.h
// Purpose:         Implements gnBaseSource for ABI files
// Description:     
// Changes:        
// Version:         libGenome 0.1.0 
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////
#ifndef _gnABISource_h_
#define _gnABISource_h_

#include "gn/gnDefs.h"

#include <string>
#include "gn/gnFileSource.h"
#include "gn/gnFileContig.h"
#include "gn/gnSourceSpec.h"
#include "gn/gnFilter.h"

/**
 * gnABISource is not implemented.
 */
class GNDLLEXPORT gnABISource : public gnFileSource
{
public:
	gnABISource();	
	/**
	 * Clone Constructor copies the specified gnSEQSource.
	 * @param s The gnABISource to copy.
	 */
	gnABISource( const gnABISource& s );
	~gnABISource();
	gnABISource* Clone() const;

	uint32 GetContigListLength() const;
	boolean HasContig( const string& name ) const;
	uint32 GetContigID( const string& name ) const;
	string GetContigName( uint32 i ) const;
	gnSeqI GetContigSeqLength( uint32 i ) const;
	gnFileContig* GetContig( const uint32 i ) const;

	boolean SeqRead( const gnSeqI start, char* buf, uint32& bufLen, const uint32 contigI=ALL_CONTIGS );

	/**
	 * Writes the specified gnSequence to an ABI file named "filename".
	 * @param sequence The gnSequence to write out.
	 * @param filename The name of the file to write.
	 * @return True if successful, false otherwise.
	 */
	static boolean Write(gnSequence& sequence, const string& filename);
	gnGenomeSpec *GetSpec() const;

	gnFileContig* GetFileContig( const uint32 contigI ) const;
private:
	boolean SeqSeek( const gnSeqI start, const uint32& contigI, uint64& startPos, uint64& readableBytes );
	boolean SeqStartPos( const gnSeqI start, gnFileContig& contig, uint64& startPos, uint64& readableBytes );
	boolean ParseStream( istream& fin );

	gnGenomeSpec *m_spec;
	vector< gnFileContig* > m_contigList;	

};// class gnABISource

inline
gnABISource* gnABISource::Clone() const
{
	return new gnABISource( *this );
}
inline
uint32 gnABISource::GetContigListLength() const
{
	return m_contigList.size();
}
inline
gnGenomeSpec *gnABISource::GetSpec() const
{
	return m_spec->Clone();
}

#endif
	// _gnABISource_h_
