/////////////////////////////////////////////////////////////////////////////
// File:            gnBaseFilter.h
// Purpose:         Generic filter interface
// Description:     Filters sequences, translates, reverse complement, converts
//                   additions, etc.
// Changes:        
// Version:         libGenome 0.1.0 
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////
#ifndef _gnBaseFilter_h_
#define _gnBaseFilter_h_

#include "gn/gnDefs.h"

#include <string>
#include "gn/gnClone.h"
#include "gn/gnDefs.h"

class GNDLLEXPORT gnBaseFilter : public gnClone
{
public:		
	virtual gnBaseFilter* Clone() const = 0;
	
	/**
	 * Gets the name of this filter
	 * @return the filter name 
	 */
	virtual string GetName() const;
	/**
	 * Sets the name of this filter
	 * @param name the new filter name
	 */
	virtual void SetName( string name );
	
	/**
	 * Filter the given character
	 * @param ch The character to filter
	 * @return The filtered character
	 */
	virtual gnSeqC Filter( const gnSeqC ch ) const = 0;

	/**
	 * Filter the given character array
	 * @param seq A pointer to the character array
	 * @param len the length of the character array to filter
	 * @return The filtered character
	 */
	virtual void Filter( gnSeqC** seq, uint32& len ) const = 0;

	/**
	 * Filters the given string
	 * @param seq The string to filter
	 */
	virtual void Filter( string &seq ) const = 0;

protected:
	string m_name;

};//class gnBaseFilter

inline
string gnBaseFilter::GetName() const
{
	return m_name;
}
inline
void gnBaseFilter::SetName( string name )
{
	m_name = name;
}

#endif
	// _gnBaseFilter_h_
