/////////////////////////////////////////////////////////////////////////////
// File:            gn/gnDebug.h
// Purpose:         Debug header used for libGenome
// Description:     Debug defines all debuging tools used for libGenome
// Rev:             A
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////

#ifndef _gnDebug_h_
#define _gnDebug_h_

#ifdef GN_GUI
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"
#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
#endif //GN_GUI

#include "gn/gnDefs.h"
#include <string>
#include <iostream>

#ifdef COMMAND_LINE

const boolean USE_COMMAND_LINE = true;
const boolean USE_GUI = false;

#elif defined(GN_GUI)

const boolean USE_COMMAND_LINE = false;
const boolean USE_GUI = true;

#else

const boolean USE_COMMAND_LINE = false;
const boolean USE_GUI = false;

#endif
GNDLLEXPORT void DebugMsg(string a);
inline
void DebugMsg(string a){
	if(USE_COMMAND_LINE){
		cout << a;
	}else if(USE_GUI){
#ifdef GN_GUI
		wxString debugstring = a.c_str();
		wxMessageDialog wxmd2(NULL, debugstring, "Debug Message", wxOK | wxCENTRE | wxICON_INFORMATION);
		wxmd2.ShowModal();
#endif
	}
}

GNDLLEXPORT void ErrorMsg(string a);
inline
void ErrorMsg(string a){
	if(USE_COMMAND_LINE){
		cout << a;
	}else if(USE_GUI){
#ifdef GN_GUI
		wxString errorstring = a.c_str();
		wxMessageDialog wxmd2(NULL, errorstring, "Error Message", wxOK | wxCENTRE | wxICON_HAND);
		wxmd2.ShowModal();
#endif
	}
}

#endif
	//_gnDebug_h_
