/////////////////////////////////////////////////////////////////////////////
// File:            gnFastTranslator.h
// Purpose:         Fast translator for all Sequences
// Description:     Caches translations of each possible sequence in a tree
// Changes:        
// Version:         libGenome 0.1.0 
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////
#ifndef _gnFastTranslator_h_
#define _gnFastTranslator_h_


#include "gn/gnDefs.h"

#include <string>
#include <iostream>
#include <vector>
#include <map>
#include "gn/gnClone.h"
#include "gn/gnBaseFilter.h"
#include "gn/gnTranslator.h"

class GNDLLEXPORT gnFastTranslator : public gnBaseFilter
{
public:

	static const gnFastTranslator *ProteinDNATranslator();
	static const gnFastTranslator *DNAProteinTranslator();

	enum gnTranslatorType{
		ProteinDNATranslatorType,
		DNAProteinTranslatorType,
	};

	gnFastTranslator();
	gnFastTranslator( gnTranslatorType t_type );
	gnFastTranslator( const gnFastTranslator& sf );
	gnFastTranslator& operator= (const gnFastTranslator& sf);
	gnFastTranslator* Clone() const;
	
	/**
	 * Queries the specified gnTranslator for every possible combination translation
	 * of the characters specified in the inputs string.  An input_width may be specified
	 * so that every possible combination of "input_width" characters in "inputs" will be
	 * cached.  This is useful for DNA to protein translations, for example.
	 * @param tranny The gnTranslator to cache.
	 * @param inputs The characters to cache from tranny.
	 * @param input_width The number of characters in each query to make to tranny.
	 */
	virtual void CacheTranslator(const gnTranslator* tranny, string inputs, const gnSeqI input_width);

	// gnSeqC 
	virtual gnSeqC Filter( const gnSeqC ch ) const;

	virtual void Filter( gnSeqC** seq, uint32& len ) const;
	// string
	virtual void Filter( string &seq ) const;

	// Default gnSeqC
	void SetDefaultChar( const gnSeqC ch1 );
	gnSeqC GetDefaultChar() const;
	void UseDefaultChar( const boolean use = true);
	// fill map
	void SetPair( const string& ch1, const string& ch2 );
	void RemovePair( const string& ch );

private:

	void CreateProteinDNATranslator();
	void CreateDNAProteinTranslator();

	//map an input string to an output string
	map<string, string> m_transCache;
	const gnTranslator * m_translator;
	
	boolean use_default;
	gnSeqC m_defaultChar;
};//class gnFastTranslator

inline
gnFastTranslator* gnFastTranslator::Clone() const
{
	return new gnFastTranslator(*this);
}

inline
void gnFastTranslator::SetDefaultChar( const gnSeqC ch1 )
{
	m_defaultChar = ch1;
	use_default = true;
}
inline
gnSeqC gnFastTranslator::GetDefaultChar() const
{
	return m_defaultChar;
}

inline
void gnFastTranslator::UseDefaultChar(const boolean use)
{
	use_default = use;
}

#endif // _gnFastTranslator_h_
