/////////////////////////////////////////////////////////////////////////////
// File:            gnStringHeader.h
// Purpose:         abstract Header class
// Description:     Provides an interface for Headers in memory.
// Changes:        
// Version:         libGenome 0.1.0 
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////
#ifndef _gnStringHeader_h_
#define _gnStringHeader_h_

#include "gn/gnDefs.h"

#include <string>
#include "gn/gnClone.h"
#include "gn/gnLocation.h"
#include "gn/gnBaseHeader.h"

/**
 * gnStringHeader stores sequence related header information in memory.
 * Use gnStringHeader for a general purpose headers.
 * @see gnBaseHeader
 */
class GNDLLEXPORT gnStringHeader : public gnBaseHeader
{
public:
	/**
	 * Empty constructor.
	 */
	gnStringHeader();
	/**
	 * Create a gnStringHeader.
	 * @param name The header name.
	 * @param header The header.
	 */
	gnStringHeader(const string& name, const string& header);
	/**
	 * Copy constructor.
	 * @param s The gnStringHeader to copy.
	 */
	gnStringHeader(const gnStringHeader& s);
	/**
	 * Destructor, frees memory.
	 */
	~gnStringHeader() {};

	gnStringHeader* Clone() const;

	string GetHeader() const;
	string GetHeaderName() const;

	/**
	 * Set the header stored in this class.
	 * @param header The header as a string.
	 */
	void SetHeader(const string& header);
	/**
	 * Set the header's name stored in this class.
	 * @param name The header name as a string.
	 */
	void SetHeaderName(const string& name);
	
	uint32 GetLength() const;
private:
	string m_name;
	string m_header;
}; //class gnStringHeader

inline
gnStringHeader::gnStringHeader(){
	m_header = string();
}
inline
gnStringHeader::gnStringHeader(const string& name, const string& header){
	m_name = name;
	m_header = header;
}
inline
gnStringHeader::gnStringHeader(const gnStringHeader& s){
	m_header = string(s.m_header);
}
inline
gnStringHeader* gnStringHeader::Clone() const{
	return new gnStringHeader(*this);
}
inline
string gnStringHeader::GetHeader() const{
	return m_header;
}
inline
string gnStringHeader::GetHeaderName() const{
	return m_name;
}
inline
void gnStringHeader::SetHeader(const string& header){
	m_header = header;
}
inline
void gnStringHeader::SetHeaderName(const string& name){
	m_name = name;
}
inline
uint32 gnStringHeader::GetLength() const{
	return m_header.length();
}

#endif
	// _gnStringHeader_h_
