#ifndef HASHMAP_H
#define HASHMAP_H

/* hashmap - a chaining hash map
 */

#define HASHMAP_SMALL 17
#define HASHMAP_MEDIUM 701
#define HASHMAP_LARGE 8191

struct hashmap;

unsigned int hash_string(const void *);

struct hashmap *hashmap_new(unsigned int size,
				unsigned int (*hash_fn)(const void *),
				void (*free_key_fn)(void *),
				void (*free_data_fn)(void *));
void hashmap_del(struct hashmap *h);

int hashmap_put(struct hashmap *h, void *key, void *data);
int hashmap_is_empty(struct hashmap *h);
unsigned int hashmap_size(struct hashmap *h);
void *hashmap_get(const struct hashmap *h, const void *key);
void hashmap_iterate(struct hashmap *h);
void *hashmap_next(struct hashmap *h);
void *hashmap_remove(struct hashmap *h, const void *key);

#endif /* HASHMAP_H */

