#ifndef LINKEDLIST_H
#define LINKEDLIST_H

/* linkedlist - a singularly linked list
 */

struct linkedlist;

struct linkedlist *linkedlist_new(unsigned int);
void linkedlist_del(struct linkedlist *l, void (*free_data_fn)(void *));

void linkedlist_clear(struct linkedlist *l, void (*free_data_fn)(void *));
int linkedlist_add(struct linkedlist *l, void *data);
int linkedlist_insert(struct linkedlist *l, unsigned int idx, void *data);
int linkedlist_insert_sorted(struct linkedlist *l,
    int (*compar)(const void *, const void *), void **replaced, void *data);
int linkedlist_is_empty(const struct linkedlist *l);
unsigned int linkedlist_size(const struct linkedlist *l);
void *linkedlist_get(const struct linkedlist *l, unsigned int idx);
void *linkedlist_get_last(const struct linkedlist *l);
void linkedlist_iterate(struct linkedlist *l);
void *linkedlist_next(struct linkedlist *l);
void *linkedlist_remove(struct linkedlist *l, unsigned int idx);
void *linkedlist_remove_last(struct linkedlist *l);
void *linkedlist_remove_data(struct linkedlist *l, void *data);
void linkedlist_toarray(struct linkedlist *l, void *array[]);

#endif /* LINKEDLIST_H */

