/* MCVE v3.x C API
   (c) 2002 by Main Street Softworks, Inc.
   Written by Brad House

   This API is being released to the public domain to be modified and used in any manor the holder of this code sees fit.
   For any questions please contact  support@mainstreetsoftworks.com
*/

#ifndef __MCVE_H__
#define __MCVE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifdef NO_LONG_LONG
/* This is wrong, but what else can we do? */
typedef unsigned long MCVE_uint64;
typedef long MCVE_int64;

#else

typedef unsigned long long MCVE_uint64;
typedef long long MCVE_int64;

#endif


/* Key definitions for Transaction Parameters */
#define MC_TRANTYPE	1
#define MC_USERNAME	2
#define MC_PASSWORD	3
#define MC_ACCOUNT	4
#define MC_TRACKDATA	5
#define MC_EXPDATE	6
#define MC_STREET	7
#define MC_ZIP		8
#define MC_CV		9
#define MC_COMMENTS	10
#define MC_CLERKID	11
#define MC_STATIONID	12
#define MC_APPRCODE	13
#define MC_AMOUNT	14
#define MC_PTRANNUM	15
#define MC_TTID		16
#define MC_USER		17
#define MC_PWD		18
#define MC_ACCT		19
#define MC_BDATE		20
#define MC_EDATE		21
#define MC_BATCH		22
#define MC_FILE		23
#define MC_ADMIN		24
#define MC_AUDITTYPE	25
#define MC_CUSTOM	26

/* Args for adding a user */
#define MC_USER_PROC		2000
#define MC_USER_USER		2001
#define MC_USER_PWD		2002
#define MC_USER_INDCODE		2003
#define MC_USER_MERCHID		2004
#define MC_USER_BANKID		2005
#define MC_USER_TERMID		2006
#define MC_USER_CLIENTNUM	2007
#define MC_USER_STOREID		2008
#define MC_USER_AGENTID		2009
#define MC_USER_CHAINID		2010
#define MC_USER_ZIPCODE		2011
#define MC_USER_TIMEZONE	2012
#define MC_USER_MERCHCAT	2013
#define MC_USER_MERNAME		2014
#define MC_USER_MERCHLOC	2015
#define MC_USER_STATECODE	2016
#define MC_USER_PHONE		2017

/* Value definitions for Transaction Types */
#define MC_TRAN_SALE	1
#define MC_TRAN_PREAUTH	2
#define MC_TRAN_VOID	3
#define MC_TRAN_PREAUTHCOMPLETE	4
#define MC_TRAN_FORCE	5
#define MC_TRAN_OVERRIDE	6
#define MC_TRAN_RETURN	7
#define MC_TRAN_SETTLE	8
#define MC_TRAN_ADMIN	50
#define MC_TRAN_PING	100
#define MC_TRAN_CHKPWD	200

/* Engine Admin Transaction Types */
#define MC_TRAN_CHNGPWD		1001
#define MC_TRAN_LISTSTATS	1002
#define MC_TRAN_LISTUSERS	1003
#define MC_TRAN_GETUSERINFO	1004
#define MC_TRAN_ADDUSER		1005
#define MC_TRAN_EDITUSER	1006
#define MC_TRAN_DELUSER		1007
#define MC_TRAN_ENABLEUSER	1008
#define MC_TRAN_DISABLEUSER	1009
#define MC_TRAN_IMPORT		1010
#define MC_TRAN_EXPORT		1011


/* Value definitions for Admin Types */
#define MC_ADMIN_GUT		1
#define MC_ADMIN_GL		2
#define MC_ADMIN_GFT		3
#define MC_ADMIN_BT		4
#define MC_ADMIN_UB		MC_ADMIN_BT
#define MC_ADMIN_QC		5
#define MC_ADMIN_RS		6
#define MC_ADMIN_CTH		7
#define MC_ADMIN_CFH		8
#define MC_ADMIN_FORCESETTLE	9
#define MC_ADMIN_SETBATCHNUM	10

/* Transaction States */
#define MCVE_UNUSED 0
#define MCVE_NEW 100
#define MCVE_PENDING 1
#define MCVE_DONE 2

/* Transaction Results */
#define MCVE_ERROR -1
#define MCVE_FAIL 0
#define MCVE_SUCCESS 1
#define MCVE_AUTH 2
#define MCVE_DENY 3
#define MCVE_CALL 4
#define MCVE_DUPL 5
#define MCVE_PKUP 6
#define MCVE_RETRY 7
#define MCVE_SETUP 8
#define MCVE_TIMEOUT 9

// AVS/CVV2 response codes
#define MCVE_GOOD 1
#define MCVE_BAD 0
#define MCVE_STREET 2
#define MCVE_ZIP 3
#define MCVE_UNKNOWN -1

typedef void * MCVE_CONN;

/* BASE ROUTINES */
int MCVE_InitEngine(char *location);
void MCVE_DestroyEngine();
void MCVE_InitConn(MCVE_CONN *myconn);
int MCVE_SetBlocking(MCVE_CONN *myconn, int tf);
int MCVE_SetTimeout(MCVE_CONN *myconn, long timeout);
int MCVE_SetDropFile(MCVE_CONN *myconn, char *df_location);
int MCVE_SetIP(MCVE_CONN *myconn, char *host, unsigned long port);
int MCVE_SetSSL(MCVE_CONN *myconn, char *host, unsigned long port);
void MCVE_VerifyConnection(MCVE_CONN *myconn, int tf);
void MCVE_VerifySSLCert(MCVE_CONN *myconn, int tf);
int MCVE_Connect(MCVE_CONN *myconn);
void MCVE_MaxConnTimeout(MCVE_CONN *myconn, int maxtime);
char *MCVE_ConnectionError(MCVE_CONN *myconn);
void MCVE_DestroyConn(MCVE_CONN *myconn);
int MCVE_Monitor(MCVE_CONN *myconn);
int MCVE_TransactionsSent(MCVE_CONN *myconn);
long MCVE_Ping(MCVE_CONN *myconn);
#define MCVE_DeleteResponse(a, b) MCVE_DeleteTrans(a, b)
void MCVE_DeleteTrans(MCVE_CONN *myconn, long identifier);

long MCVE_TransNew(MCVE_CONN *myconn);
int MCVE_TransParam(MCVE_CONN *myconn, long identifier, int key, ...);
int MCVE_TransSend(MCVE_CONN *myconn, long identifier);
char *MCVE_ResponseParam(MCVE_CONN *myconn, long identifier, char *key);


/* Transaction Routines */
long MCVE_Sale(MCVE_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                               char *street, char *zip, char *cv, char *comments, char *clerkid, char *stationid, long ptrannum);
long MCVE_PreAuth(MCVE_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                                     char *street, char *zip, char *cv, char *comments, char *clerkid, char *stationid, long ptrannum);
long MCVE_Void(MCVE_CONN *myconn, char *username, char *password, MCVE_int64 ttid, long ptrannum);
long MCVE_PreAuthCompletion(MCVE_CONN *myconn, char *username, char *password, double finalamount, MCVE_int64 ttid, long ptrannum);
long MCVE_Force(MCVE_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                char *authcode, char *comments, char *clerkid, char *stationid, long ptrannum);
long MCVE_Return(MCVE_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                                     char *comments, char *clerkid, char *stationid, long ptrannum);
long MCVE_Override(MCVE_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                                     char *street, char *zip, char *cv, char *comments, char *clerkid, char *stationid, long ptrannum);
long MCVE_Settle(MCVE_CONN *myconn, char *username, char *password, char *batch);


/* Response Checking Routines */
int MCVE_ReturnStatus(MCVE_CONN *myconn, long identifier);
int MCVE_ReturnCode(MCVE_CONN *myconn, long identifier);
long MCVE_TransactionItem(MCVE_CONN *myconn, long identifier);
long MCVE_TransactionBatch(MCVE_CONN *myconn, long identifier);
MCVE_int64 MCVE_TransactionID(MCVE_CONN *myconn, long identifier);
char *MCVE_TransactionAuth(MCVE_CONN *myconn, long identifier);
char *MCVE_TransactionText(MCVE_CONN *myconn, long identifier);
int MCVE_TransactionAVS(MCVE_CONN *myconn, long identifier);
int MCVE_TransactionCV(MCVE_CONN *myconn, long identifier);
long MCVE_TransInQueue(MCVE_CONN *myconn);
int MCVE_CheckStatus(MCVE_CONN *myconn, long trans);
long MCVE_CompleteAuthorizations(MCVE_CONN *myconn, long **listings);


/* User-level administrative requests */

long MCVE_Gut(MCVE_CONN *myconn, char *username, char *password, int type, char *acct, char *clerkid, char *stationid, char *comments,
                              double ptrannum, char *bdate, char *edate);
long MCVE_Gl(MCVE_CONN *myconn, char *username, char *password, int type, char *acct, char *batch, char *clerkid, char *stationid, char *comments,
                              double ptrannum, char *bdate, char *edate);
long MCVE_Gft(MCVE_CONN *myconn, char *username, char *password, int type, char *acct, char *clerkid, char *stationid, char *comments,
                              double ptrannum, char *bdate, char *edate);
//long MCVE_Ub(MCVE_CONN *myconn, char *username, char *password);
long MCVE_Rs(MCVE_CONN *myconn, char *username, char *password, char *stationid);
long MCVE_Qc(MCVE_CONN *myconn, char *username, char *password, char *clerkid, char *stationid, char *comments, double ptrannum);
long MCVE_Chkpwd(MCVE_CONN *myconn, char *username, char *password);
long MCVE_Bt(MCVE_CONN *myconn, char *username, char *password);
#define MCVE_Ub(a,b,c) MCVE_Bt(a,b,c)

/* Engine-Admin requests */

long MCVE_Chngpwd(MCVE_CONN *myconn, char *adminpwd, char *newpassword);
long MCVE_ListUsers(MCVE_CONN *myconn, char *adminpwd);
long MCVE_EnableUser(MCVE_CONN *myconn, char *adminpwd, char *user);
long MCVE_DisableUser(MCVE_CONN *myconn, char *adminpwd, char *user);
long MCVE_GetUserInfo(MCVE_CONN *myconn, char *adminpwd, char *user);
long MCVE_DelUser(MCVE_CONN *myconn, char *adminpwd, char *user);
long MCVE_ListStats(MCVE_CONN *myconn, char *adminpwd);
long MCVE_Export(MCVE_CONN *myconn, char *adminpwd, char *filename);
long MCVE_Import(MCVE_CONN *myconn, char *adminpwd, char *filename);

/* Reading special administrative responses */

char *MCVE_GetUserParam(MCVE_CONN *myconn, long identifier, int key);

/* Comma Delimited Routines */
int MCVE_IsCommaDelimited(MCVE_CONN *myconn, long identifier);
int MCVE_ParseCommaDelimited(MCVE_CONN *myconn, long identifier);
char *MCVE_GetCommaDelimited(MCVE_CONN *myconn, long identifier);
char *MCVE_GetCell(MCVE_CONN *myconn, long identifier, char *column, long row);
char *MCVE_GetCellByNum(MCVE_CONN *myconn, long identifier, int column, long row);
int MCVE_NumColumns(MCVE_CONN *myconn, long identifier);
long MCVE_NumRows(MCVE_CONN *myconn, long identifier);
char *MCVE_GetHeader(MCVE_CONN *myconn, long identifier, int column_num);
 

/* ----------------EMULATION SEGMENT---------------------------
 * Strictly for emulating old "user" functions
 */
 
#define MCVE_SALE 1
#define MCVE_PREAUTH 2
#define MCVE_FORCE 3
#define MCVE_OVERRIDE 4
#define MCVE_RETURN 5
#define MCVE_VOID 6
#define MCVE_SETTLE 7 
 
// USER SETUP INFORMATION
#define MCVE_PROC MC_USER_PROC
#define MCVE_USER MC_USER_USER
#define MCVE_PWD MC_USER_PWD
#define MCVE_INDCODE MC_USER_INDCODE
#define MCVE_MERCHID MC_USER_MERCHID
#define MCVE_BANKID MC_USER_BANKID
#define MCVE_TERMID MC_USER_TERMID
#define MCVE_CLIENTNUM MC_USER_CLIENTNUM
#define MCVE_STOREID MC_USER_STOREID
#define MCVE_AGENTID MC_USER_AGENTID
#define MCVE_CHAINID MC_USER_CHAINID
#define MCVE_ZIPCODE MC_USER_ZIPCODE
#define MCVE_TIMEZONE MC_USER_TIMEZONE
#define MCVE_MERCHCAT MC_USER_MERCHCAT
#define MCVE_MERNAME MC_USER_MERNAME
#define MCVE_MERCHLOC MC_USER_MERCHLOC
#define MCVE_STATECODE MC_USER_STATECODE
#define MCVE_SERVICEPHONE MC_USER_PHONE

typedef void * MCVE_UserSetup;

long MCVE_AddUser(MCVE_CONN *myconn, char *adminpwd, MCVE_UserSetup *setup);
long MCVE_EditUser(MCVE_CONN *myconn, char *adminpwd, MCVE_UserSetup *setup);
void MCVE_InitUserSetup(MCVE_UserSetup *setup);
void MCVE_DeleteUserSetup(MCVE_UserSetup *setup);
char *MCVE_GetUserArg(MCVE_UserSetup *usersetup, int argtype);
int MCVE_AddUserArg(MCVE_UserSetup *setup, int argtype, char *argval);


int MCVE_uwait(unsigned long length);

/* TEXT RESPONSE CONVERSIONS */

char *MCVE_TEXT_Code(int code);
char *MCVE_TEXT_AVS(int code);
char *MCVE_TEXT_CV(int code);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
