/* $Id: shhcards.h,v 1.1.1.1 1997/02/21 20:31:47 sverrehu Exp $ */
#ifndef SHHCARDS_H
#define SHHCARDS_H

#ifdef __cplusplus
  extern "C" {
#endif

#include <X11/Xlib.h>         /* Pixmap */

#define CARD_WIDTH        71  /* width of a card in pixels */
#define CARD_HEIGHT       96  /* height of a card in pixels */

#define CARD_NUM_BACKS     4  /* number of card background pictures */
#define CARD_NUM_OUTLINES  3  /* number of card outline pictures */

/* DONT'T change the order of the following defines! */
/* indexes into the cardFront array */
#define CARD_CLUBS         0
#define CARD_DIAMONDS      1
#define CARD_HEARTS        2
#define CARD_SPADES        3
/* to allow drawing backgrounds, use suit=CARD_BACKGROUND */
#define CARD_BACKGROUND    4
/* to allow drawing outlines, use suit=CARD_OUTLINE */
#define CARD_OUTLINE       5

void cardInit(Display *dpy, Drawable d);
void cardFinish(void);
void cardDraw(Drawable d, int x, int y, int suit, int value);

#ifdef __cplusplus
  }
#endif

#endif
