/*
 * Copyright (c) G. Adam Stanislav
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	utf-8.h v.1
 */

#ifndef	UTF_8_INC
#define	UTF_8_INC

#include <stdio.h>

#define	UTF8INVALID	0x80000000

/* Conversions from/to files */
unsigned int fgetu8(FILE *);
int fputu8(unsigned int, FILE *);

#define utf8fgetc	fgetu8
#define	utf8getc	fgetu8
#define	utf8getchar()	fgetu8(stdin)
#define	utf8fputc	fputu8
#define	utf8putc	fputu8
#define	utf8putchar(c)	fputu8(c, stdout)

/* Conversions from/to strings */
unsigned int sgetu8(unsigned char *, int *);
char * sputu8(unsigned int, char *);

#define	utf8sgetc	sgetu8
#define	utf8sputc	sputu8

#endif	/* UTF_8_INC defined */

